/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.NovacomDevice;
import com.palm.novacom.internal.NovacomDeviceList;
import com.palm.novacom.internal.NovacomSocketStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class NovacomController
implements INovacomController {
    private final String host;
    private final int port;

    public NovacomController(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public INovacomDevice connectDefaultDevice() throws IOException, NovacomException {
        NovaDeviceInfo[] devices = this.getDeviceList();
        if (devices.length <= 0) {
            throw new NovacomException(-1, "No devices attached on " + this.host + "@" + this.port);
        }
        return this.connectToDevice(devices[0]);
    }

    public INovacomDevice connectToDevice(NovaDeviceInfo devInfo) throws IOException, NovacomException {
        if (devInfo == null) {
            throw new NovacomException(-22, "Invalid device info(null)");
        }
        return new NovacomDevice(this.host, devInfo);
    }

    public NovaDeviceInfo[] getDeviceList() throws IOException, NovacomException {
        Socket socket = new Socket(this.host, this.port);
        NovacomSocketStream stream = new NovacomSocketStream(socket, "Device List Stream");
        stream.setPacketMode(false);
        NovacomDeviceList deviceList = new NovacomDeviceList(stream);
        NovaDeviceInfo[] list = deviceList.getDevices();
        try {
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private NovaDeviceInfo[] getDeviceListOnTransport(String transport) throws IOException, NovacomException {
        NovaDeviceInfo[] list = this.getDeviceList();
        ArrayList<NovaDeviceInfo> arrayList = new ArrayList<NovaDeviceInfo>(list.length);
        if (list.length > 0) {
            NovaDeviceInfo[] novaDeviceInfoArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                NovaDeviceInfo device = novaDeviceInfoArray[n2];
                if (transport.equals(device.getTransport())) {
                    arrayList.add(device);
                }
                ++n2;
            }
        }
        return arrayList.toArray(new NovaDeviceInfo[0]);
    }

    public NovaDeviceInfo[] getDeviceListOnUsb() throws IOException, NovacomException {
        return this.getDeviceListOnTransport("usb");
    }

    public NovaDeviceInfo[] getDeviceListOnTcp() throws IOException, NovacomException {
        return this.getDeviceListOnTransport("tcp");
    }
}

