/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomStream;
import com.palm.novacom.internal.NovacomBaseStream;
import com.palm.novacom.internal.OOBPacket;
import com.palm.novacom.internal.PacketReader;
import com.palm.novacom.internal.PacketWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NovacomSocketStream
extends NovacomBaseStream
implements INovacomStream {
    private final Socket socket;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final PacketReader packetReader;
    private final PacketWriter packetWriter;
    private boolean packetMode;
    private boolean outputClosed;
    private boolean inputClosed;
    private final String cmdUsedForStream;
    private final Logger logger = Logger.getLogger("com.palm.novacom");

    NovacomSocketStream(Socket socket, String cmdUsedForStream) throws IOException {
        this.socket = socket;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.packetReader = new PacketReader(this.inputStream);
        this.packetWriter = new PacketWriter(this.outputStream);
        this.packetMode = true;
        this.outputClosed = false;
        this.inputClosed = false;
        this.cmdUsedForStream = cmdUsedForStream;
    }

    public void closeOutput() throws IOException {
        if (this.packetMode && !this.outputClosed) {
            try {
                this.packetWriter.writeOutOfBand(OOBPacket.closeFilenoHeader(0));
            }
            catch (IOException e) {
                this.logger.warning("Handled Exception Cmd: " + this.cmdUsedForStream + "\n" + e);
            }
            this.outputClosed = true;
        }
    }

    public void closeInput() throws IOException {
        if (this.packetMode && !this.inputClosed) {
            try {
                this.packetWriter.writeOutOfBand(OOBPacket.closeFilenoHeader(1));
                this.packetWriter.writeOutOfBand(OOBPacket.closeFilenoHeader(2));
            }
            catch (IOException e) {
                this.logger.warning("Handled Exception Cmd: " + this.cmdUsedForStream + "\n" + e);
            }
            this.inputClosed = true;
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public int waitForReturnCode() throws IOException {
        try {
            int rc;
            while ((rc = this.packetReader.readPacket()) >= 0) {
            }
        }
        catch (Exception e) {
            this.logger.warning("Handled Exception Cmd: " + this.cmdUsedForStream + "\n" + e);
        }
        Vector<OOBPacket> oobPackets = this.packetReader.getOOBPackets();
        for (OOBPacket oob : oobPackets) {
            int messageType = oob.getMessageType();
            if (messageType != 2) continue;
            return oob.getMessagePayload();
        }
        IOException e = new IOException("No return code found in stream from " + this.cmdUsedForStream);
        this.logger.warning("Throwing Exception Cmd: " + this.cmdUsedForStream + "\n" + e);
        throw e;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public int read() throws IOException {
        try {
            if (this.isPacketMode()) {
                return this.packetReader.read();
            }
            return this.inputStream.read();
        }
        catch (SocketException e) {
            this.handleSocketException(e);
            return -1;
        }
    }

    public int read(byte[] b, int minBytesToRead) throws IOException {
        if (b == null) {
            return -1;
        }
        int i = 0;
        while (i < b.length) {
            int val;
            if (i >= minBytesToRead && this.readMightBlock() || (val = this.read()) == -1) break;
            b[i] = (byte)val;
            ++i;
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        try {
            if (this.isPacketMode()) {
                return this.packetReader.read(b);
            }
            return this.inputStream.read(b);
        }
        catch (SocketException e) {
            this.handleSocketException(e);
            return -1;
        }
    }

    public void write(int b) throws IOException {
        try {
            if (this.packetMode) {
                this.packetWriter.write(b);
            } else {
                this.outputStream.write(b);
            }
        }
        catch (SocketException e) {
            this.handleSocketException(e);
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            if (this.packetMode) {
                this.packetWriter.write(b);
            } else {
                this.outputStream.write(b);
            }
        }
        catch (SocketException e) {
            this.handleSocketException(e);
        }
    }

    private void handleSocketException(SocketException e) throws SocketException {
        this.logger.warning("SocketException Cmd: " + this.cmdUsedForStream);
        if (e.getMessage().startsWith("Broken pipe")) {
            SocketException e2;
            try {
                int retCode = this.waitForReturnCode();
                e2 = new SocketException("Broken pipe from " + this.cmdUsedForStream + ", return code: " + retCode);
            }
            catch (IOException eIO) {
                e2 = new SocketException("Broken pipe from " + this.cmdUsedForStream);
            }
            e2.setStackTrace(e.getStackTrace());
            e = e2;
        }
        throw e;
    }

    public void setPacketMode(boolean enabled) {
        this.packetMode = enabled;
    }

    public boolean isPacketMode() {
        return this.packetMode;
    }

    public boolean readMightBlock() {
        return !this.packetMode || this.packetReader.atPacketStart();
    }

    public void sendSignal(int i) throws IOException {
        if (!this.packetMode) {
            throw new IOException();
        }
        try {
            this.packetWriter.writeOutOfBand(OOBPacket.sendSignal(i));
        }
        catch (SocketException e) {
            this.logger.log(Level.WARNING, "Exception Returned from Out of Band Write.  Could be pipe closed too quickly", e);
        }
    }

    public void sendResize(int cols, int rows) throws IOException {
        if (!this.packetMode) {
            throw new IOException();
        }
        try {
            this.packetWriter.writeOutOfBand(OOBPacket.sendResize(cols, rows));
        }
        catch (SocketException e) {
            this.logger.log(Level.WARNING, "Exception Returned from Out of Band Write.  Could be pipe closed too quickly", e);
        }
    }
}

