/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.connect;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import com.palm.webos.connect.JSDebuggerStream;
import com.palm.webos.connect.JSNovacomRunStream;
import com.palm.webos.installer.Installer;
import com.palm.webos.launcher.Launcher;
import com.palm.webos.util.novacom.NovacomUtil;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import netscape.javascript.JSObject;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceConnection
extends Applet {
    private static final long serialVersionUID = -5898442491801428005L;
    private static final String version = "0.2.1";
    private AccessControlContext accessControlContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        DeviceConnection deviceConnection = this;
        synchronized (deviceConnection) {
            this.accessControlContext = AccessController.getContext();
        }
    }

    protected synchronized AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public String getVersion() {
        return version;
    }

    public JSDebuggerStream connectToDebugger(final String deviceId, final String onDataFunc, final String onDisconnectFunc, final int debuggerPort) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<JSDebuggerStream>(){

            @Override
            public JSDebuggerStream run() throws Exception {
                JSObject window = JSObject.getWindow((Applet)DeviceConnection.this);
                JSObject on_data = DeviceConnection.getJSObject(onDataFunc, window);
                JSObject on_disconnect = DeviceConnection.getJSObject(onDisconnectFunc, window);
                JSDebuggerStream stream = new JSDebuggerStream(deviceId, debuggerPort, window, on_data, on_disconnect);
                return stream;
            }
        }, this.getAccessControlContext());
    }

    public JSDebuggerStream connectToDebugger(String deviceId, String onDataFunc, String onDisconnectFunc) throws PrivilegedActionException {
        return this.connectToDebugger(deviceId, onDataFunc, onDisconnectFunc, 5858);
    }

    public static NovaDeviceInfo findNovacomDevice(String deviceId) throws NovacomUtil.NovacomUtilException {
        NovaDeviceInfo[] deviceInfos;
        for (NovaDeviceInfo deviceInfo : deviceInfos = NovacomUtil.findNovacomDevices(null, 0, deviceId)) {
            if (!deviceInfo.getUIDString().equals(deviceId)) continue;
            return deviceInfo;
        }
        return null;
    }

    public static NovaDeviceInfo getDefaultNovacomDevice() throws IOException, NovacomException {
        NovaDeviceInfo[] deviceInfos = Novacom.getController().getDeviceList();
        if (deviceInfos.length > 0) {
            return deviceInfos[0];
        }
        return null;
    }

    public String getDefaultDeviceId() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                NovaDeviceInfo deviceInfo = DeviceConnection.getDefaultNovacomDevice();
                return deviceInfo == null ? null : deviceInfo.getUIDString();
            }
        }, this.getAccessControlContext());
    }

    public String getDeviceName(final String deviceId) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                NovaDeviceInfo deviceInfo = DeviceConnection.findNovacomDevice(deviceId);
                return deviceInfo.getMachineName();
            }
        }, this.getAccessControlContext());
    }

    public String listDevices() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    NovaDeviceInfo[] list = Novacom.getController().getDeviceList();
                    JSONArray listArray = new JSONArray();
                    for (int i = 0; i < list.length; ++i) {
                        JSONObject device = new JSONObject();
                        device.put("UID", list[i].getUIDString());
                        device.put("name", list[i].getName());
                        device.put("machineName", list[i].getMachineName());
                        device.put("transport", list[i].getTransport());
                        device.put("port", list[i].getPort());
                        listArray.put(device);
                    }
                    return listArray.toString();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return "";
        }
    }

    public boolean installCloudPackage(final String deviceId, final String location, final String pkgName, final String headers) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    InputStream input = null;
                    try {
                        HttpURLConnection connection = (HttpURLConnection)new URL(location).openConnection();
                        JSONObject headerObj = new JSONObject(headers);
                        Iterator a = headerObj.keys();
                        while (a.hasNext()) {
                            String key = a.next().toString();
                            connection.addRequestProperty(key, headerObj.getString(key));
                        }
                        connection.connect();
                        if (connection.getResponseCode() != 200) {
                            throw new Exception(connection.getResponseMessage());
                        }
                        input = connection.getInputStream();
                        new Installer().installPackage(NovacomUtil.connect(DeviceConnection.findNovacomDevice(deviceId)), input, pkgName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    return null;
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            return false;
        }
    }

    public boolean installFilePackage(final String deviceId, final String fileName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    new Installer().installPackage(NovacomUtil.connect(DeviceConnection.findNovacomDevice(deviceId)), new File(fileName));
                    return null;
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            return false;
        }
    }

    public boolean launchApp(final String deviceId, final String appName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    new Launcher().launchApp(NovacomUtil.connect(DeviceConnection.findNovacomDevice(deviceId)), appName, null);
                    return null;
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            return false;
        }
    }

    public boolean removeApp(final String deviceId, final String appName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    new Installer().removeApp(NovacomUtil.connect(DeviceConnection.findNovacomDevice(deviceId)), appName);
                    return null;
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            return false;
        }
    }

    public String listApps(final String deviceId) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    INovacomDevice dev = NovacomUtil.connect(DeviceConnection.findNovacomDevice(deviceId));
                    return new Installer().listApps(dev).toString();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return "";
        }
    }

    public String restartLunaSysMgr(final String deviceId) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                NovaDeviceInfo info;
                NovaDeviceInfo deviceInfo = DeviceConnection.getDefaultNovacomDevice();
                NovaDeviceInfo novaDeviceInfo = info = deviceId == null ? deviceInfo : DeviceConnection.findNovacomDevice(deviceId);
                if (info != null) {
                    INovacomDevice device = NovacomUtil.connect(info);
                    device.runProgram("/usr/bin/killall -s KILL LunaSysMgr", null);
                }
                return null;
            }
        }, this.getAccessControlContext());
    }

    public String getNovacomdVersion(final String deviceId) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                NovaDeviceInfo info;
                NovaDeviceInfo novaDeviceInfo = info = deviceId == null ? DeviceConnection.getDefaultNovacomDevice() : DeviceConnection.findNovacomDevice(deviceId);
                if (info != null) {
                    String line;
                    INovacomDevice device = NovacomUtil.connect(info);
                    INovacomStream stream = device.runProgram("/usr/bin/ipkg info novacomd", null);
                    StringBuffer sb = new StringBuffer();
                    while ((line = stream.readLine()).length() > 0) {
                        if (!line.startsWith("Version")) continue;
                        sb.append(line);
                    }
                    try {
                        stream.flush();
                        stream.closeInput();
                        stream.closeOutput();
                        stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return sb.toString();
                }
                return null;
            }
        }, this.getAccessControlContext());
    }

    public JSNovacomRunStream executeNovacomCommand(final String deviceId, final String command, final String onDataFunc, final String onDisconnectFunc) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<JSNovacomRunStream>(){

            @Override
            public JSNovacomRunStream run() throws Exception {
                JSObject window = JSObject.getWindow((Applet)DeviceConnection.this);
                JSObject on_data = DeviceConnection.getJSObject(onDataFunc, window);
                JSObject on_disconnect = DeviceConnection.getJSObject(onDisconnectFunc, window);
                JSNovacomRunStream stream = new JSNovacomRunStream(deviceId, command, window);
                stream.on_data = on_data;
                stream.on_disconnect = on_disconnect;
                return stream;
            }
        }, this.getAccessControlContext());
    }

    public JSNovacomRunStream connectToLogger(String deviceId, String onDataFunc, String onDisconnectFunc) throws PrivilegedActionException {
        return this.executeNovacomCommand(deviceId, "/usr/bin/tail -f /var/log/messages", onDataFunc, onDisconnectFunc);
    }

    private static JSObject getJSObject(String func, JSObject window) {
        String[] split = func.split("\\.");
        JSObject jsObject = window;
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            jsObject = (JSObject)jsObject.getMember(s);
        }
        return jsObject;
    }
}

