/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.connect;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.DirectConnection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import netscape.javascript.JSObject;

public abstract class JSConnectStream {
    public JSObject on_data;
    public JSObject on_disconnect;
    protected INovacomStream out;

    public static INovacomStream executeNovacomCommand(INovacomDevice device, String cmd, String[] args, AsyncExecutionDelegate stdoutDelegate) throws NovacomException, IOException {
        INovacomStream stream = device.runProgram(cmd, args);
        return JSConnectStream.connect(stream, false, stdoutDelegate);
    }

    public static INovacomStream connectPort(INovacomDevice device, int port, AsyncExecutionDelegate stdoutDelegate) throws NovacomException, IOException {
        boolean isDirectConnection;
        INovacomStream stream;
        if (device instanceof DirectConnection) {
            stream = ((DirectConnection)device).getSocketStream();
            isDirectConnection = true;
        } else {
            stream = device.connectDevicePort(port);
            isDirectConnection = false;
        }
        return JSConnectStream.connect(stream, isDirectConnection, stdoutDelegate);
    }

    private static INovacomStream connect(final INovacomStream stream, final boolean isDirectConnection, final AsyncExecutionDelegate stdoutDelegate) throws NovacomException, IOException {
        new Thread(new Runnable(){

            public void run() {
                StringBuilder buf = new StringBuilder();
                boolean endPacket = false;
                while (true) {
                    int c;
                    if ((isDirectConnection ? endPacket : stream.readMightBlock()) && buf.length() > 0) {
                        stdoutDelegate.received(buf.toString());
                        buf.setLength(0);
                    }
                    try {
                        c = stream.read();
                    }
                    catch (IOException e) {
                        c = -1;
                    }
                    if (c < 0) {
                        try {
                            if (buf.length() > 0) {
                                stdoutDelegate.received(buf.toString());
                            }
                            stdoutDelegate.returned(stream.waitForReturnCode());
                        }
                        catch (IOException e) {
                            stdoutDelegate.returned(-1);
                        }
                        try {
                            stream.closeInput();
                            stream.closeOutput();
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    buf.append((char)c);
                    endPacket = c == 10 || c == 125;
                }
            }
        }).start();
        return stream;
    }

    public final boolean connected() {
        return this.out != null;
    }

    public void disconnect() throws IOException {
        if (this.out != null) {
            try {
                this.out.sendSignal(15);
                this.out.closeOutput();
                this.out.closeInput();
                this.out.close();
            }
            catch (IOException e) {
                this.out.close();
            }
        }
    }

    public synchronized void send(String data) throws UnsupportedEncodingException, IOException {
        if (this.out != null) {
            this.out.write(data.getBytes("UTF-8"));
        }
    }

    public static interface AsyncExecutionDelegate {
        public void received(String var1);

        public void returned(int var1);
    }
}

