/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.connect;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.DirectConnection;
import com.palm.webos.connect.DeviceConnection;
import com.palm.webos.connect.JSConnectStream;
import com.palm.webos.util.novacom.NovacomUtil;
import java.io.IOException;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class JSDebuggerStream
extends JSConnectStream {
    static final int DEBUGGER_PORT = 5858;

    JSDebuggerStream(String deviceName, int debuggerPort, final JSObject window, JSObject ondata, JSObject ondisconnect) throws NovacomUtil.NovacomUtilException, NovacomException, IOException {
        this.on_data = ondata;
        this.on_disconnect = ondisconnect;
        JSConnectStream.AsyncExecutionDelegate delegate = new JSConnectStream.AsyncExecutionDelegate(){

            public void received(String data) {
                try {
                    Object[] args = new Object[]{window, data};
                    JSDebuggerStream.this.on_data.call("call", args);
                }
                catch (JSException e) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void returned(int code) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    JSDebuggerStream.this.out = null;
                }
                try {
                    Object[] args = new Object[]{window, code};
                    JSDebuggerStream.this.on_disconnect.call("call", args);
                }
                catch (JSException e) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        };
        INovacomDevice device = null;
        if (deviceName.equals("desktop")) {
            device = new DirectConnection("localhost", debuggerPort);
            this.out = JSDebuggerStream.connectPort(device, debuggerPort, delegate);
        } else {
            NovaDeviceInfo info = deviceName == null ? DeviceConnection.getDefaultNovacomDevice() : DeviceConnection.findNovacomDevice(deviceName);
            device = NovacomUtil.connect(info);
            device.runProgram("/usr/bin/luna-send", new String[]{"-n", "0", "palm://com.palm.systemmanager/setJavascriptFlags", "{\"flags\":\"--debugger_agent\"}"});
            device.runProgram("/usr/bin/luna-send", new String[]{"-n", "0", "palm://com.palm.systemmanager/debugger", "{\"enable\":true}"});
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.out = info.getMachineName().equals("emulator") ? JSDebuggerStream.executeNovacomCommand(device, "/usr/bin/nc localhost " + debuggerPort, null, delegate) : JSDebuggerStream.connectPort(device, debuggerPort, delegate);
        }
    }
}

