/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.dndfileupload;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNDApplet
extends Applet
implements DropTargetListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String version = "0.1";
    private static final int TOTAL_UPLOAD_SIZE_LIMIT = 10000;
    private JTextPane dropDisplayPane;
    private StringBuffer dropDisplayPaneContent = new StringBuffer("");
    private JScrollPane scrollPane;
    private DropTarget dropTarget;
    private JButton uploadButton;
    private JButton cancelButton;
    private JProgressBar progressBar;
    private List<File> fileList = new ArrayList<File>();
    private JSObject window = null;
    private Thread uploaderThread;
    private String uploadErrorMsg = null;
    private String prefix = "";
    private String username = null;
    private String password = null;
    private String authtkt = null;
    private String uploadPath = null;
    private String metadata = null;

    @Override
    public void init() {
        try {
            this.window = JSObject.getWindow((Applet)this);
        }
        catch (JSException e1) {
            System.out.println("Cannot get a reference to the container window:" + e1.getMessage());
        }
        this.setLayout(new BorderLayout());
        this.dropDisplayPane = new JTextPane();
        this.dropDisplayPane.setContentType("text/html");
        this.dropDisplayPane.setEditable(false);
        this.dropDisplayPane.setBackground(new Color(14, 16, 17));
        this.scrollPane = new JScrollPane(this.dropDisplayPane);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.dropTarget = new DropTarget(this.dropDisplayPane, this);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.uploadButton = new JButton("Upload");
        this.uploadButton.addActionListener(this);
        this.uploadButton.setEnabled(false);
        this.cancelButton = new JButton("Clear");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(false);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setEnabled(false);
        this.progressBar.setStringPainted(true);
    }

    private void onMouseOverDropTarget(boolean ontop) {
        String t = ontop ? "<html><body style='text-align:center; padding:5; color:\"#EEEEEE\" '>Drop to start uploading</body></html>" : "";
        this.dropDisplayPane.setText(t);
    }

    private Object makeJsCall(String jsFunc, Object[] args) {
        String[] split = jsFunc.split("\\.");
        JSObject func = this.window;
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (i + 1 == split.length) {
                return func.call(s, args);
            }
            func = (JSObject)func.getMember(s);
        }
        return null;
    }

    public String getVersion() {
        return version;
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setAuthtkt(String authtkt) {
        this.authtkt = authtkt;
    }

    public void setMetadata(String md) {
        this.metadata = md;
    }

    public void setUploadPath(String path) {
        this.uploadPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.uploadButton) {
            this.uploadFiles();
        } else if (e.getSource() == this.cancelButton) {
            if (this.uploaderThread != null && this.uploaderThread.isAlive()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DNDApplet.this.cancelButton.setText("Cancelling upload..");
                        DNDApplet.this.cancelButton.setEnabled(false);
                        DNDApplet.this.display("Cancelling upload...");
                    }
                });
                this.uploaderThread.interrupt();
                try {
                    this.uploaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.display("<p><font color=red>Upload interrupted.</font></p>");
                    this.resetInput();
                }
            } else {
                this.display(null);
                this.resetInput();
            }
        }
    }

    private void display(String msg) {
        if (msg == null) {
            this.dropDisplayPaneContent = new StringBuffer("");
        } else {
            this.dropDisplayPaneContent.append(msg);
        }
        String html = "<html><head><style>body { font: Arial 8px }</style></head><body>" + this.dropDisplayPaneContent.toString() + "</body>" + "</html>";
    }

    public void resetInput() {
        this.fileList.clear();
        this.uploadButton.setText("Upload");
        this.uploadButton.setEnabled(false);
        this.cancelButton.setText("Clear");
        this.cancelButton.setEnabled(false);
    }

    private void uploadFiles() {
        this.uploaderThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DNDApplet.this.display(null);
                if (DNDApplet.this.fileList.isEmpty()) {
                    return;
                }
                if (DNDApplet.this.uploadErrorMsg != null) {
                    String funcName5 = DNDApplet.this.getParameter("funcNameHandleError");
                    if (funcName5 != null && DNDApplet.this.window != null) {
                        try {
                            System.out.println("funcNameHandleError: " + DNDApplet.this.uploadErrorMsg);
                            DNDApplet.this.makeJsCall(funcName5, new Object[]{DNDApplet.this.uploadErrorMsg});
                        }
                        catch (JSException e) {
                            System.out.println(e.getMessage());
                        }
                        finally {
                            DNDApplet.this.fileList.clear();
                            DNDApplet.this.uploadErrorMsg = null;
                        }
                    }
                    return;
                }
                Long number = new Long(DNDApplet.this.fileList.size());
                String funcName = DNDApplet.this.getParameter("funcNameHandleStartUpload");
                if (funcName != null && DNDApplet.this.window != null) {
                    try {
                        DNDApplet.this.makeJsCall(funcName, new Object[]{number});
                    }
                    catch (JSException e) {
                        System.out.println(e.getMessage());
                    }
                }
                if (DNDApplet.this.uploadPath == null || DNDApplet.this.uploadPath.length() == 0) {
                    DNDApplet.this.fileList.clear();
                    return;
                }
                DNDApplet.this.uploadButton.setText("Uploading files, please wait...");
                DNDApplet.this.cancelButton.setText("Cancel upload");
                DNDApplet.this.uploadButton.setEnabled(false);
                String url = DNDApplet.this.getDocumentBase().toString();
                if (DNDApplet.this.uploadPath == null) {
                    DNDApplet.this.uploadPath = DNDApplet.this.getParameter("uploadPath") != null ? DNDApplet.this.getParameter("uploadPath") : "file/upload/UserFiles/images";
                }
                url = url.substring(0, 5).compareTo("file:") == 0 ? "http://localhost:8080" : url.substring(0, url.lastIndexOf("/"));
                url = url + "/" + DNDApplet.this.uploadPath;
                HttpURLConnection.setFollowRedirects(false);
                HttpURLConnection conn = null;
                String authHash = null;
                if (DNDApplet.this.username != null && DNDApplet.this.password != null) {
                    String s = DNDApplet.this.username + ":" + DNDApplet.this.password;
                    authHash = new BASE64Encoder().encode(s.getBytes());
                }
                boolean hasError = false;
                for (int i = 0; i < DNDApplet.this.fileList.size(); ++i) {
                    if (Thread.currentThread().isInterrupted()) continue;
                    File f = (File)DNDApplet.this.fileList.get(i);
                    String funcName2 = DNDApplet.this.getParameter("funcNameHandleCurrentUpload");
                    if (funcName2 != null && DNDApplet.this.window != null) {
                        try {
                            DNDApplet.this.makeJsCall(funcName2, new Object[]{f.getName()});
                        }
                        catch (JSException e3) {
                            System.out.println(e3.getMessage());
                        }
                    }
                    int fileSize = (int)Math.floor((double)f.length() / 1024.0);
                    final String msg = "Uploading " + f.getName() + " (" + fileSize + "kB) ...<br>";
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DNDApplet.this.display(msg);
                        }
                    });
                    String fileName = DNDApplet.this.prefix + f.getName();
                    try {
                        String line;
                        conn = (HttpURLConnection)new URL(url).openConnection();
                        conn.setRequestProperty("Cookie", "auth_tkt=" + DNDApplet.this.authtkt);
                        if (authHash != null) {
                            conn.setDoInput(true);
                            conn.setRequestProperty("Authorization", "Basic " + authHash);
                            conn.connect();
                            conn.disconnect();
                        }
                        conn.setRequestMethod("POST");
                        String boundary = "boundary220394209402349823";
                        String tail = "\r\n--" + boundary + "--\r\n";
                        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                        conn.setDoOutput(true);
                        String metadataPart = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"metadata\"\r\n\r\n" + DNDApplet.this.metadata + "\r\n";
                        String fileHeader1 = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"uploadfile\"; filename=\"" + fileName + "\"\r\n" + "Content-Type: application/octet-stream\r\n" + "Content-Transfer-Encoding: binary\r\n";
                        long fileLength = f.length();
                        String fileHeader2 = "Content-length: " + fileLength + "\r\n";
                        String fileHeader = fileHeader1 + fileHeader2 + "\r\n";
                        String stringData = metadataPart + fileHeader;
                        long requestLength = (long)stringData.length() + fileLength;
                        conn.setRequestProperty("Content-length", "" + requestLength);
                        conn.setFixedLengthStreamingMode((int)requestLength);
                        conn.connect();
                        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                        out.writeBytes(stringData);
                        out.flush();
                        DNDApplet.this.progressBar.setMinimum(0);
                        DNDApplet.this.progressBar.setMaximum((int)f.length());
                        int progress = 0;
                        int bytesRead = 0;
                        byte[] b = new byte[1024];
                        BufferedInputStream bufin = new BufferedInputStream(new FileInputStream(f));
                        while ((bytesRead = bufin.read(b)) != -1) {
                            if (Thread.currentThread().isInterrupted()) {
                                // empty if block
                            }
                            out.write(b, 0, bytesRead);
                            out.flush();
                            final int p = progress += bytesRead;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DNDApplet.this.progressBar.setValue(p);
                                    DNDApplet.this.progressBar.revalidate();
                                }
                            });
                        }
                        bufin.close();
                        out.flush();
                        out.close();
                        if (conn.getResponseCode() == 200) continue;
                        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                        StringBuffer sb = new StringBuffer();
                        while ((line = rd.readLine()) != null) {
                            sb.append(line);
                        }
                        throw new Exception(sb.toString());
                    }
                    catch (Exception e) {
                        hasError = true;
                        String funcName3 = DNDApplet.this.getParameter("funcNameHandleError");
                        if (funcName3 != null && DNDApplet.this.window != null) {
                            try {
                                DNDApplet.this.makeJsCall(funcName3, new Object[]{e.getMessage()});
                            }
                            catch (JSException e3) {
                                System.out.println(e3.getMessage());
                            }
                        }
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
                DNDApplet.this.fileList.clear();
                DNDApplet.this.uploadButton.setText("Upload finished.");
                DNDApplet.this.cancelButton.setText("Clear");
                DNDApplet.this.cancelButton.setEnabled(false);
                if (hasError) {
                    return;
                }
                String funcName4 = DNDApplet.this.getParameter("funcNameHandleEndUpload");
                if (funcName4 != null && DNDApplet.this.window != null) {
                    try {
                        DNDApplet.this.makeJsCall(funcName4, new Object[]{DNDApplet.this.uploadPath});
                    }
                    catch (JSException e4) {
                        System.out.println(e4.getMessage());
                    }
                }
            }
        });
        this.uploaderThread.start();
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.onMouseOverDropTarget(false);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.onMouseOverDropTarget(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.onMouseOverDropTarget(false);
        int action = dtde.getDropAction();
        dtde.acceptDrop(action);
        this.fromTransferable(dtde.getTransferable());
        dtde.dropComplete(true);
        this.uploadFiles();
    }

    private void fromTransferable(Transferable t) {
        if (t == null) {
            return;
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                this.addToFileList(list);
            } else {
                boolean isMimeTypeFileList;
                DataFlavor[] flavors = t.getTransferDataFlavors();
                DataFlavor df = DataFlavor.selectBestTextFlavor(flavors);
                String mimeType = df.getMimeType();
                String representationClass = df.getDefaultRepresentationClassAsString();
                boolean bl = isMimeTypeFileList = mimeType.indexOf("text/uri-list") > -1;
                if (representationClass == "java.io.InputStream") {
                    String funcName1;
                    String line;
                    StringBuffer sb = new StringBuffer("");
                    Object td = t.getTransferData(df);
                    InputStreamReader r = td instanceof ByteArrayInputStream ? new InputStreamReader((ByteArrayInputStream)td) : (InputStreamReader)td;
                    ArrayList<File> list = new ArrayList<File>();
                    BufferedReader in = new BufferedReader(r);
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                        if (!isMimeTypeFileList) continue;
                        URL url = new URL(line);
                        list.add(new File(url.getFile()));
                    }
                    if (isMimeTypeFileList) {
                        this.addToFileList(list);
                    }
                    if ((funcName1 = this.getParameter("funcNameHandleStringMimeType")) != null && this.window != null) {
                        try {
                            this.makeJsCall(funcName1, new Object[]{mimeType, sb.toString()});
                        }
                        catch (JSException e1) {
                            System.out.println(e1.getMessage());
                        }
                    }
                } else {
                    Object data = t.getTransferData(df);
                    String funcName2 = this.getParameter("funcNameHandleUnknownMimeType");
                    if (funcName2 != null && this.window != null) {
                        try {
                            this.makeJsCall(funcName2, new Object[]{mimeType, data});
                        }
                        catch (JSException e2) {
                            System.out.println(e2.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addToFileList(List<File> list) {
        if (!this.fileList.containsAll(list)) {
            for (File f : list) {
                if (!f.isFile()) continue;
                this.fileList.add(f);
            }
            this.uploadButton.setText("Upload " + this.fileList.size() + " files.");
        }
        this.display(null);
        int totalSize = 0;
        for (int i = 0; i < this.fileList.size(); ++i) {
            File f = this.fileList.get(i);
            String fileName = f.getName();
            int fileSize = (int)Math.floor((double)f.length() / 1024.0);
            totalSize += fileSize;
            this.display(fileName + " (" + fileSize + " kB)<br>");
        }
        if (totalSize > 10000) {
            this.uploadErrorMsg = "File upload size limit exceeded.";
        }
        this.uploadButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }
}

