/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.installer;

import com.palm.novacom.INovacomDevice;
import com.palm.webos.installer.InstallerException;
import com.palm.webos.util.AppManagerUtil;
import com.palm.webos.util.novacom.NovacomCommand;
import com.palm.webos.util.novacom.NovacomPutCommand;
import com.palm.webos.util.novacom.NovacomUtil;
import java.io.File;
import java.io.InputStream;
import org.json.JSONArray;

public class Installer {
    private static final String DEVELOPER_DIR = "/media/internal/.developer";

    private static String getDeveloperDirectory() {
        return DEVELOPER_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPackage(INovacomDevice device, File ipkFile) throws InstallerException {
        if (!ipkFile.isFile() || !ipkFile.canRead()) {
            throw new InstallerException("error reading " + ipkFile);
        }
        String developerDir = Installer.getDeveloperDirectory();
        try {
            NovacomUtil.mkdir(device, developerDir, true);
        }
        catch (NovacomUtil.NovacomUtilException e) {
            throw new InstallerException(e);
        }
        String dest = developerDir + "/" + ipkFile.getName();
        try {
            try {
                NovacomPutCommand cmd = new NovacomPutCommand(device, ipkFile, dest);
                cmd.run();
            }
            catch (NovacomCommand.NovacomCommandException e) {
                throw new InstallerException(e);
            }
            try {
                AppManagerUtil.installApp(device, dest);
            }
            catch (AppManagerUtil.AppManagerException e) {
                throw new InstallerException(e);
            }
        }
        finally {
            try {
                this.doCleanup(device, dest);
            }
            catch (InstallerException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPackage(INovacomDevice device, InputStream input, String pkgName) throws InstallerException {
        String developerDir = Installer.getDeveloperDirectory();
        try {
            NovacomUtil.mkdir(device, developerDir, true);
        }
        catch (NovacomUtil.NovacomUtilException e) {
            throw new InstallerException(e);
        }
        String dest = developerDir + "/" + pkgName;
        try {
            try {
                NovacomPutCommand cmd = new NovacomPutCommand(device, input, dest);
                cmd.run();
            }
            catch (NovacomCommand.NovacomCommandException e) {
                throw new InstallerException(e);
            }
            try {
                AppManagerUtil.installApp(device, dest);
            }
            catch (AppManagerUtil.AppManagerException e) {
                throw new InstallerException(e);
            }
        }
        finally {
            try {
                this.doCleanup(device, dest);
            }
            catch (InstallerException e) {}
        }
    }

    private void doCleanup(INovacomDevice device, String dest) throws InstallerException {
        try {
            NovacomUtil.rm(device, dest, true);
        }
        catch (NovacomUtil.NovacomUtilException e) {
            throw new InstallerException(e);
        }
    }

    public void removeApp(INovacomDevice device, String appId) throws InstallerException {
        try {
            AppManagerUtil.removeApp(device, appId);
        }
        catch (AppManagerUtil.AppManagerException e) {
            throw new InstallerException(e);
        }
    }

    public JSONArray listApps(INovacomDevice device) throws InstallerException {
        try {
            return AppManagerUtil.listApps(device);
        }
        catch (AppManagerUtil.AppManagerException e) {
            throw new InstallerException(e);
        }
    }
}

