/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util;

import com.palm.novacom.INovacomDevice;
import com.palm.webos.util.Logging;
import com.palm.webos.util.LunaSendCommand;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppManagerUtil {
    private static final int LIST_TIMEOUT = 120;
    private static final int OPEN_TIMEOUT = 30;
    private static final int CLOSE_TIMEOUT = 30;
    private static final int INSPECT_TIMEOUT = 30;
    private static final int INSTALL_TIMEOUT = 120;
    private static final int REMOVE_TIMEOUT = 120;

    public static JSONArray listApps(INovacomDevice device) throws AppManagerException {
        int result;
        final JSONArray[] responseArray = new JSONArray[]{null};
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                responseArray[0] = data.getJSONArray("apps");
                this.setMessage("SUCCESS");
                return 2;
            }
        };
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.applicationManager", "listApps", new JSONObject());
        try {
            result = command.run(handler, 120);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
        return responseArray[0];
    }

    public static JSONArray listRunningApps(INovacomDevice device) throws AppManagerException {
        int result;
        final JSONArray[] responseArray = new JSONArray[]{null};
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                responseArray[0] = data.getJSONArray("running");
                this.setMessage("SUCCESS");
                return 2;
            }
        };
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.applicationManager", "running", new JSONObject());
        try {
            result = command.run(handler, 120);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
        return responseArray[0];
    }

    public static JSONObject findApp(INovacomDevice device, String appId) throws AppManagerException {
        JSONArray apps = AppManagerUtil.listApps(device);
        try {
            for (int i = 0; i < apps.length(); ++i) {
                JSONObject obj = (JSONObject)apps.get(i);
                String id = obj.getString("id");
                if (!appId.equals(id)) continue;
                return obj;
            }
        }
        catch (JSONException e) {
            throw new AppManagerException(e);
        }
        return null;
    }

    public static String getRemoteProcessId(INovacomDevice device, String appId) throws AppManagerException {
        JSONArray running = AppManagerUtil.listRunningApps(device);
        try {
            for (int i = 0; i < running.length(); ++i) {
                JSONObject obj = (JSONObject)running.get(i);
                String id = obj.getString("id");
                if (!appId.equals(id)) continue;
                return obj.getString("processid");
            }
        }
        catch (JSONException e) {
            throw new AppManagerException(e);
        }
        return null;
    }

    public static void launchApp(INovacomDevice device, String appId, JSONObject params) throws AppManagerException {
        int result;
        JSONObject appInfo = AppManagerUtil.findApp(device, appId);
        if (appInfo == null) {
            throw new AppManagerException("application " + appId + " not found");
        }
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                boolean retVal = data.getBoolean("returnValue");
                if (!retVal) {
                    this.setMessage("returned false");
                    return 1;
                }
                String processId = data.getString("processId");
                return 2;
            }
        };
        JSONObject obj = new JSONObject();
        try {
            obj.put("id", appId);
            if (params != null && params.length() > 0) {
                obj.put("params", params);
            }
        }
        catch (JSONException e) {
            throw new AppManagerException(e);
        }
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.applicationManager", "launch", obj);
        try {
            result = command.run(handler, 30);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
    }

    public static void inspectApp(INovacomDevice device, String appId) throws AppManagerException {
        JSONObject appInfo = AppManagerUtil.findApp(device, appId);
        if (appInfo == null) {
            throw new AppManagerException("application " + appId + " not found");
        }
        String processId = AppManagerUtil.getRemoteProcessId(device, appId);
        if (processId == null) {
            Logging.getLogger().finest("app not running - nothing to do");
            return;
        }
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSONException(String data, JSONException e) {
                return 2;
            }

            public int gotText(String line) {
                return 2;
            }

            public int gotJSON(JSONObject data) throws JSONException {
                return 2;
            }
        };
        JSONObject obj = new JSONObject();
        try {
            obj.put("processId", processId);
        }
        catch (JSONException e) {
            throw new AppManagerException(e);
        }
        LunaSendCommand command = new LunaSendCommand(device, new String[0], "com.palm.applicationManager", "inspect", obj);
        try {
            int result = command.run(handler, 30);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
    }

    public static void closeApp(INovacomDevice device, String appId) throws AppManagerException {
        JSONObject appInfo = AppManagerUtil.findApp(device, appId);
        if (appInfo == null) {
            throw new AppManagerException("application " + appId + " not found");
        }
        AppManagerUtil.doCloseApp(device, appId);
    }

    private static void doCloseApp(INovacomDevice device, String appId) throws AppManagerException {
        int result;
        String processId = AppManagerUtil.getRemoteProcessId(device, appId);
        if (processId == null) {
            Logging.getLogger().finest("app not running - nothing to do");
            return;
        }
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                boolean retVal = data.getBoolean("returnValue");
                if (!retVal) {
                    this.setMessage("returned false");
                    return 1;
                }
                return 2;
            }
        };
        JSONObject obj = new JSONObject();
        try {
            obj.put("processId", processId);
        }
        catch (JSONException e) {
            throw new AppManagerException(e);
        }
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.applicationManager", "close", obj);
        try {
            result = command.run(handler, 30);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
    }

    public static void installApp(INovacomDevice device, String ipkFile) throws AppManagerException {
        int result;
        final int[] lineCount = new int[]{0};
        final String[] ticket = new String[]{null};
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                if (lineCount[0] == 0) {
                    boolean retVal = data.getBoolean("returnValue");
                    if (!retVal) {
                        this.setMessage("returned false");
                        return 1;
                    }
                    boolean sub = data.getBoolean("subscribed");
                    if (!sub) {
                        this.setMessage("subscribed false");
                        return 1;
                    }
                    ticket[0] = data.getString("ticket");
                    lineCount[0] = lineCount[0] + 1;
                } else {
                    if (ticket[0] == null) {
                        this.setMessage("no ticket was received");
                        return 1;
                    }
                    String statusTicket = data.getString("ticket");
                    if (ticket[0].equals(statusTicket)) {
                        String status = data.getString("status");
                        if (status.startsWith("FAILED_")) {
                            this.setMessage(status);
                            return 1;
                        }
                        if (status.startsWith("SUCCESS")) {
                            this.setMessage(status);
                            return 2;
                        }
                        lineCount[0] = lineCount[0] + 1;
                    }
                }
                return 0;
            }
        };
        JSONObject params = new JSONObject();
        try {
            params.put("target", ipkFile);
            params.put("subscribe", true);
            params.put("uncompressedSize", 0);
        }
        catch (JSONException e1) {
            throw new AppManagerException(e1);
        }
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.appinstaller", "installNoVerify", params);
        try {
            result = command.run(handler, 120);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
    }

    public static void removeApp(INovacomDevice device, String appId) throws AppManagerException {
        int result;
        JSONObject appInfo = AppManagerUtil.findApp(device, appId);
        if (appInfo == null) {
            throw new AppManagerException("application " + appId + " not found");
        }
        AppManagerUtil.doCloseApp(device, appId);
        final int[] lineCount = new int[]{0};
        final String[] ticket = new String[]{null};
        LunaSendCommand.LunaSendResponseHandler handler = new LunaSendCommand.LunaSendResponseHandler(){

            public int gotJSON(JSONObject data) throws JSONException {
                if (lineCount[0] == 0) {
                    boolean retVal = data.getBoolean("returnValue");
                    if (!retVal) {
                        this.setMessage("returned false");
                        return 1;
                    }
                    ticket[0] = data.getString("ticket");
                    lineCount[0] = lineCount[0] + 1;
                    return 0;
                }
                if (ticket[0] == null) {
                    this.setMessage("no ticket was received");
                    return 1;
                }
                String statusTicket = data.getString("ticket");
                if (ticket[0].equals(statusTicket)) {
                    String status = data.getString("status");
                    if (status.startsWith("FAILED_")) {
                        this.setMessage(status);
                        return 1;
                    }
                    if (status.startsWith("SUCCESS")) {
                        this.setMessage(status);
                        return 2;
                    }
                    lineCount[0] = lineCount[0] + 1;
                }
                return 0;
            }
        };
        JSONObject obj = new JSONObject();
        try {
            obj.put("packageName", appId);
            obj.put("subscribe", true);
        }
        catch (JSONException e1) {
            throw new AppManagerException(e1);
        }
        LunaSendCommand command = new LunaSendCommand(device, new String[]{"-i"}, "com.palm.appinstaller", "remove", obj);
        try {
            result = command.run(handler, 120);
        }
        catch (LunaSendCommand.LunaSendException e) {
            throw new AppManagerException(e);
        }
        if (result != 2) {
            String reason = handler.getMessage();
            if (reason != null) {
                throw new AppManagerException(reason);
            }
            throw new AppManagerException("luna-send failed");
        }
    }

    public static class AppManagerException
    extends Exception {
        private static final long serialVersionUID = 4885110223478026312L;

        public AppManagerException(String message) {
            super(message);
        }

        public AppManagerException(Throwable t) {
            super(t);
        }
    }
}

