/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    private JsonUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJSONObject(File jsonFile) throws IOException, JSONException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(jsonFile)));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JSONObject jSONObject = new JSONObject(builder.toString());
            return jSONObject;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray readJSONArray(File jsonFile) throws IOException, JSONException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(jsonFile)));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JSONArray jSONArray = new JSONArray(builder.toString());
            return jSONArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static JSONObject parseAsJson(String text, boolean expandNestedKeys) throws JSONException {
        String trimmed = JsonUtil.stripOuterQuotes(text.trim()).trim();
        JSONObject result = trimmed.length() == 0 ? new JSONObject() : (trimmed.length() >= 2 && trimmed.charAt(0) == '{' && trimmed.charAt(trimmed.length() - 1) == '}' ? new JSONObject(trimmed) : new JSONObject("{ " + text + " }"));
        if (expandNestedKeys) {
            JSONObject nestedResult = new JSONObject();
            JsonUtil.expandKeys(nestedResult, result);
            return nestedResult;
        }
        return result;
    }

    private static void expandKeys(JSONObject container, JSONObject source) throws JSONException {
        Iterator it = source.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key == null || key.length() <= 0) continue;
            Object value = source.get(key);
            if (value instanceof JSONObject) {
                JSONObject subContainer = new JSONObject();
                JsonUtil.expandKeys(subContainer, (JSONObject)value);
                JsonUtil.expandKey(container, key, subContainer);
                continue;
            }
            JsonUtil.expandKey(container, key, value);
        }
    }

    private static void expandKey(JSONObject container, String key, Object valueObj) throws JSONException {
        String[] segments = key.split("\\.");
        if (segments.length > 1) {
            JSONObject outer = (JSONObject)container.opt(segments[0]);
            if (outer == null) {
                outer = new JSONObject();
                container.put(segments[0], outer);
            }
            JSONObject inner = outer;
            for (int i = 1; i < segments.length - 1; ++i) {
                String name = segments[i];
                JSONObject curr = (JSONObject)inner.opt(name);
                if (curr == null) {
                    curr = new JSONObject();
                    inner.put(name, curr);
                }
                inner = curr;
            }
            inner.put(segments[segments.length - 1], valueObj);
        } else {
            container.put(key, valueObj);
        }
    }

    private static String stripOuterQuotes(String str) {
        char last;
        char first;
        if (str.length() > 1 && ((first = str.charAt(0)) == '\'' || first == '\"') && first == (last = str.charAt(str.length() - 1))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void merge(JSONObject dest, JSONObject src) throws JSONException {
        Iterator it = src.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key == null || key.length() <= 0) continue;
            Object value = src.get(key);
            Object existing = dest.opt(key);
            if (existing != null) {
                if (existing instanceof JSONObject) {
                    if (value instanceof JSONObject) {
                        JsonUtil.merge((JSONObject)existing, (JSONObject)value);
                        continue;
                    }
                    throw new JSONException("cannot assign value to object \"" + key + "\"");
                }
                if (value instanceof JSONObject) {
                    throw new JSONException("cannot assign object to value \"" + key + "\"");
                }
                dest.put(key, value);
                continue;
            }
            dest.put(key, value);
        }
    }

    public static void populateKeyMap(Map<String, String> map, JSONObject src) throws JSONException {
        JsonUtil.populateKeyMap(map, src, "");
    }

    private static void populateKeyMap(Map<String, String> map, JSONObject src, String keyPrefix) throws JSONException {
        Iterator it = src.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key == null || key.length() <= 0) continue;
            Object value = src.get(key);
            if (value instanceof JSONArray) {
                throw new JSONException("arrays not supported");
            }
            if (value instanceof JSONObject) {
                JsonUtil.populateKeyMap(map, (JSONObject)value, keyPrefix + key + ".");
                continue;
            }
            map.put(keyPrefix + key, String.valueOf(value));
        }
    }
}

