/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import com.palm.webos.util.Logging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.json.JSONException;
import org.json.JSONObject;

public class LunaSendCommand {
    private static final String MESSAGE_RESPONSE_PREFIX = "** Message: serviceResponse Handling: 2,";
    private INovacomDevice device;
    private String[] lunaSendOpts;
    private String lunaService;
    private String method;
    private JSONObject params;

    public LunaSendCommand(INovacomDevice device, String[] lunaSendOpts, String lunaService, String method, JSONObject params) {
        this.device = device;
        this.lunaSendOpts = new String[lunaSendOpts.length];
        System.arraycopy(lunaSendOpts, 0, this.lunaSendOpts, 0, lunaSendOpts.length);
        this.lunaService = lunaService;
        this.method = method;
        this.params = params;
    }

    public int run(final LunaSendResponseHandler handler, int timeoutSecs) throws LunaSendException {
        block31: {
            String command = "/usr/bin/luna-send";
            ArrayList<String> commandArgs = new ArrayList<String>();
            for (String opt : this.lunaSendOpts) {
                commandArgs.add(opt);
            }
            commandArgs.add("luna://" + this.lunaService + "/" + this.method);
            if (this.params != null) {
                String par = this.params.toString();
                commandArgs.add(par);
            }
            String[] args = commandArgs.toArray(new String[commandArgs.size()]);
            if (Logging.getLogger().isLoggable(Level.FINEST)) {
                StringBuilder buf = new StringBuilder();
                buf.append(command);
                for (String a : args) {
                    buf.append(' ');
                    buf.append(a);
                }
                Logging.getLogger().finest(buf.toString());
            }
            INovacomStream stream = null;
            final INovacomStream[] watchStream = new INovacomStream[]{null};
            try {
                int result;
                String line;
                watchStream[0] = stream = this.device.runProgram(command, args);
                Runnable streamMonitor = new Runnable(){

                    public void run() {
                        while (!handler.isFinished() && watchStream[0] != null) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (watchStream[0] != null) {
                            INovacomStream strm = watchStream[0];
                            watchStream[0] = null;
                            try {
                                strm.sendSignal(2);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
                new Thread(streamMonitor).start();
                while (watchStream[0] != null && (line = stream.readLine()).length() > 0) {
                    int status;
                    line = line.trim();
                    Logging.getLogger().finest(line);
                    if (line.startsWith(MESSAGE_RESPONSE_PREFIX) && line.length() > MESSAGE_RESPONSE_PREFIX.length()) {
                        line = line.substring(MESSAGE_RESPONSE_PREFIX.length()).trim();
                    }
                    try {
                        JSONObject data = new JSONObject(line);
                        status = handler.gotJSON(data);
                        if (status == 0) continue;
                        handler.setStatus(status);
                    }
                    catch (JSONException e) {
                        Logging.getLogger().log(Level.WARNING, "invalid json response", e);
                        status = handler.gotJSONException(line, e);
                        if (status == 0) continue;
                        handler.setStatus(status);
                    }
                }
                if (watchStream[0] == null) break block31;
                try {
                    stream.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    stream.closeInput();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    stream.closeOutput();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!handler.isFinished() && (result = stream.waitForReturnCode()) != 0) {
                    handler.setStatus(1);
                    handler.setMessage("return code " + result);
                }
            }
            catch (IOException e) {
                if (!handler.isFinished()) {
                    throw new LunaSendException(e);
                }
            }
            catch (NovacomException e) {
                throw new LunaSendException(e);
            }
            finally {
                if (watchStream[0] != null) {
                    watchStream[0] = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return handler.getStatus();
    }

    public static class LunaSendException
    extends Exception {
        private static final long serialVersionUID = 2143029381631755158L;

        public LunaSendException(String message) {
            super(message);
        }

        public LunaSendException(Throwable t) {
            super(t);
        }
    }

    public static class LunaSendResponseHandler {
        private String message;
        private int result = 0;
        private boolean aborted = false;
        public static final int STATUS_CONTINUE = 0;
        public static final int STATUS_ERROR = 1;
        public static final int STATUS_SUCCESS = 2;

        public int gotJSON(JSONObject data) throws JSONException {
            return 0;
        }

        public int gotJSONException(String data, JSONException e) {
            this.setMessage(e.getMessage());
            return 1;
        }

        public int gotText(String line) {
            this.setMessage(line);
            return 1;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setStatus(int result) {
            this.result = result;
        }

        public int getStatus() {
            if (this.aborted && this.result == 0) {
                return 1;
            }
            return this.result;
        }

        public void abort() {
            this.aborted = true;
        }

        public boolean isFinished() {
            return this.aborted || this.result != 0;
        }
    }
}

