/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    private Class<?> clazz;
    private String resourcePath;

    public ResourceLoader(Class<?> clazz) {
        this.clazz = clazz;
        this.resourcePath = this.getResourcePath(clazz);
    }

    protected String getResourcePath(Class<?> c) {
        String path = c.getCanonicalName().replace('.', '/');
        int sep = path.lastIndexOf(47);
        if (sep != -1) {
            path = path.substring(0, sep);
        }
        return "/" + path;
    }

    public InputStream getResourceAsStream(String resource) throws IOException {
        InputStream input = this.clazz.getResourceAsStream(this.resourcePath + "/" + resource);
        if (input == null) {
            throw new FileNotFoundException("missing resource " + this.resourcePath + "/" + resource);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getResourceAsProperties(String resource) throws IOException {
        InputStream input = null;
        try {
            input = this.getResourceAsStream(resource);
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceAsString(String resource) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            InputStream input = this.getResourceAsStream(resource);
            reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buf.append(line + "\n");
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

