/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util.novacom;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import com.palm.webos.util.novacom.Logging;
import java.io.IOException;
import java.util.logging.Level;

public class NovacomCommand {
    public static int STATUS_OK = 0;
    public static int STATUS_CANCELLED = -1;
    private INovacomDevice device;
    private String command;
    private String[] args;
    private INovacomStream stream;

    public NovacomCommand(INovacomDevice device, String command) {
        this(device, command, null);
    }

    public NovacomCommand(INovacomDevice device, String command, String[] args) {
        this.device = device;
        this.command = command;
        if (args == null) {
            this.args = new String[0];
        } else {
            this.args = new String[args.length];
            System.arraycopy(args, 0, this.args, 0, args.length);
        }
    }

    public int run() throws NovacomCommandException {
        if (Logging.getLogger().isLoggable(Level.FINEST)) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.command);
            for (String a : this.args) {
                buf.append(' ');
                buf.append(a);
            }
            Logging.getLogger().finest(buf.toString());
        }
        this.stream = null;
        int result = -1;
        try {
            this.stream = this.device.runProgram(this.command, this.args);
            try {
                this.stream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.stream.closeInput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.stream.closeOutput();
            }
            catch (IOException e) {
                // empty catch block
            }
            result = this.stream.waitForReturnCode();
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomCommandException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomCommandException(e);
        }
        finally {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {}
                this.stream = null;
            }
        }
        return result;
    }

    public void terminate() {
        if (Logging.getLogger().isLoggable(Level.FINEST)) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.command);
            for (String a : this.args) {
                buf.append(' ');
                buf.append(a);
            }
            Logging.getLogger().finest(buf.toString());
        }
        if (this.stream != null) {
            try {
                this.stream.sendSignal(2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int run(final NovacomStreamMonitor monitor) throws NovacomCommandException {
        if (Logging.getLogger().isLoggable(Level.FINEST)) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.command);
            for (String a : this.args) {
                buf.append(' ');
                buf.append(a);
            }
            Logging.getLogger().finest(buf.toString());
        }
        this.stream = null;
        final INovacomStream[] watchStream = new INovacomStream[]{null};
        int result = -1;
        try {
            String line;
            this.stream = this.device.runProgram(this.command, this.args);
            this.stream.flush();
            watchStream[0] = this.stream;
            Runnable streamMonitor = new Runnable(){

                public void run() {
                    while (!monitor.isCancelled() && watchStream[0] != null) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (watchStream[0] != null) {
                        INovacomStream strm = watchStream[0];
                        watchStream[0] = null;
                        try {
                            strm.sendSignal(2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(streamMonitor).start();
            while ((line = this.stream.readLine()).length() > 0) {
                line = line.trim();
                Logging.getLogger().finest(line);
                if (monitor.isCancelled()) continue;
                monitor.processLine(line);
            }
            try {
                this.stream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.stream.closeInput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.stream.closeOutput();
            }
            catch (IOException e) {
                // empty catch block
            }
            result = !monitor.isCancelled() ? this.stream.waitForReturnCode() : monitor.getResult();
        }
        catch (IOException e) {
            if (!monitor.isCancelled()) {
                Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
                throw new NovacomCommandException(e);
            }
            int n = monitor.getResult();
            return n;
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomCommandException(e);
        }
        finally {
            watchStream[0] = null;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {}
                this.stream = null;
            }
        }
        return result;
    }

    public static class NovacomStreamMonitor {
        private boolean cancelled = false;
        private int result = 0;

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void processLine(String line) {
        }

        public void setResult(int result) {
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }
    }

    public static class NovacomCommandException
    extends Exception {
        private static final long serialVersionUID = -8618940374796659406L;

        public NovacomCommandException(String message) {
            super(message);
        }

        public NovacomCommandException(Throwable t) {
            super(t);
        }
    }
}

