/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util.novacom;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import com.palm.webos.util.novacom.Logging;
import com.palm.webos.util.novacom.NovacomCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class NovacomPutCommand {
    private static final int COPY_BUFFER_SIZE = 65536;
    private INovacomDevice device;
    private File src;
    private InputStream input;
    private String dest;

    public NovacomPutCommand(INovacomDevice device, File src, String dest) {
        this.device = device;
        this.src = src;
        this.dest = dest;
    }

    public NovacomPutCommand(INovacomDevice device, InputStream input, String dest) {
        this.device = device;
        this.input = input;
        this.dest = dest;
    }

    public int run() throws NovacomCommand.NovacomCommandException {
        if (this.input == null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.src);
                NovacomPutCommand.copyStream(this.device, in, this.dest);
            }
            catch (FileNotFoundException e) {
                throw new NovacomCommand.NovacomCommandException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        NovacomPutCommand.copyStream(this.device, this.input, this.dest);
        return 0;
    }

    private static void copyStream(INovacomDevice device, InputStream input, String dest) throws NovacomCommand.NovacomCommandException {
        byte[] buffer = new byte[65536];
        INovacomStream stream = null;
        try {
            stream = device.putFile(dest);
            int count = 0;
            while ((count = input.read(buffer)) != -1) {
                stream.write(buffer, 0, count);
            }
            stream.flush();
            stream.closeInput();
            stream.closeOutput();
            stream.waitForReturnCode();
        }
        catch (FileNotFoundException e) {
            throw new NovacomCommand.NovacomCommandException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomCommand.NovacomCommandException(e);
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomCommand.NovacomCommandException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

