/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.util.novacom;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import com.palm.webos.util.novacom.Logging;
import com.palm.webos.util.novacom.NovacomCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class NovacomUtil {
    private static final int NOVACOM_TIMEOUT = 10000;

    private NovacomUtil() {
    }

    public static boolean isNovacomRunning() throws NovacomNotRespondingException {
        return NovacomUtil.isNovacomRunning("127.0.0.1", 6968);
    }

    public static boolean isNovacomRunning(final String host, final int port) throws NovacomNotRespondingException {
        final String[] result = new String[]{null};
        String SUCCESS = "success";
        Runnable r = new Runnable(){

            public void run() {
                try {
                    INovacomController controller = NovacomUtil.getController(host, port);
                    NovaDeviceInfo[] devices = controller.getDeviceList();
                    result[0] = "success";
                }
                catch (IOException e) {
                    result[0] = e.toString();
                }
                catch (NovacomException e) {
                    result[0] = e.toString();
                }
                catch (Exception e) {
                    Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
                    result[0] = e.toString();
                }
            }
        };
        try {
            Thread t = new Thread(r);
            t.start();
            t.join(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (result[0] == null) {
            throw new NovacomNotRespondingException();
        }
        return result[0].equals("success");
    }

    public static String getDeviceName(NovaDeviceInfo info) {
        return String.format("\"%s\" {%s} %s %d", info.getName(), info.getUIDString().toLowerCase(), info.getTransport(), info.getPort());
    }

    public static String getDeviceName(INovacomDevice device) {
        return NovacomUtil.getDeviceName(device.getDeviceInfo());
    }

    private static INovacomController getController(String host, int port) {
        if (host == null) {
            host = "127.0.0.1";
        }
        if (port == 0) {
            port = 6968;
        }
        return Novacom.getController(host, port);
    }

    public static NovaDeviceInfo[] getNovacomDevices(String host, int port) throws NovacomUtilException {
        INovacomController controller = NovacomUtil.getController(host, port);
        try {
            return controller.getDeviceList();
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
    }

    public static String[] listDevices(String host, int port) throws NovacomUtilException {
        INovacomController controller = NovacomUtil.getController(host, port);
        ArrayList<String> deviceNames = new ArrayList<String>();
        NovaDeviceInfo[] devices = null;
        try {
            devices = controller.getDeviceList();
            if (devices != null && devices.length > 0) {
                for (NovaDeviceInfo d : devices) {
                    String deviceName = NovacomUtil.getDeviceName(d);
                    deviceNames.add(deviceName);
                }
            }
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        return deviceNames.toArray(new String[deviceNames.size()]);
    }

    public static NovaDeviceInfo[] findNovacomDevices(String host, int hport, String deviceId) throws NovacomUtilException {
        INovacomController controller = NovacomUtil.getController(host, hport);
        NovaDeviceInfo[] devices = null;
        try {
            devices = controller.getDeviceList();
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        ArrayList<NovaDeviceInfo> matches = new ArrayList<NovaDeviceInfo>();
        for (NovaDeviceInfo info : devices) {
            String uuid = info.getUIDString();
            if (uuid != null && deviceId.equalsIgnoreCase(uuid)) {
                matches.add(info);
                continue;
            }
            String name = info.getName();
            if (name != null && deviceId.equals(name)) {
                matches.add(info);
                continue;
            }
            String transport = info.getTransport();
            if (transport != null && deviceId.equalsIgnoreCase(transport)) {
                matches.add(info);
                continue;
            }
            int port = info.getPort();
            if (port == 0 || !deviceId.equals(String.valueOf(port))) continue;
            matches.add(info);
        }
        return matches.toArray(new NovaDeviceInfo[matches.size()]);
    }

    public static INovacomDevice connect(NovaDeviceInfo deviceInfo) throws NovacomUtilException {
        return NovacomUtil.connect("127.0.0.1", 6968, deviceInfo);
    }

    public static INovacomDevice connect(String host, int port, NovaDeviceInfo deviceInfo) throws NovacomUtilException {
        try {
            INovacomController controller = NovacomUtil.getController(host, port);
            return controller.connectToDevice(deviceInfo);
        }
        catch (IOException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
        catch (NovacomException e) {
            Logging.getLogger().log(Level.SEVERE, "novacom exception", e);
            throw new NovacomUtilException(e);
        }
    }

    public static void mkdir(INovacomDevice device, String dest, boolean createIntermediates) throws NovacomUtilException {
        String cmd = "/bin/mkdir";
        ArrayList<String> args = new ArrayList<String>();
        if (createIntermediates) {
            args.add("-p");
        }
        args.add(dest);
        NovacomCommand command = new NovacomCommand(device, cmd, args.toArray(new String[args.size()]));
        try {
            command.run();
        }
        catch (NovacomCommand.NovacomCommandException e) {
            throw new NovacomUtilException(e);
        }
    }

    public static void rm(INovacomDevice device, String dest, boolean force) throws NovacomUtilException {
        String cmd = "/bin/rm";
        ArrayList<String> args = new ArrayList<String>();
        if (force) {
            args.add("-f");
        }
        args.add(dest);
        NovacomCommand command = new NovacomCommand(device, cmd, args.toArray(new String[args.size()]));
        try {
            command.run();
        }
        catch (NovacomCommand.NovacomCommandException e) {
            throw new NovacomUtilException(e);
        }
    }

    public static void rmdir(INovacomDevice device, String dest, boolean recursive, boolean force) throws NovacomUtilException {
        String cmd = "/bin/rmdir";
        ArrayList<String> args = new ArrayList<String>();
        if (recursive) {
            cmd = "/bin/rm";
            args.add("-r");
            if (force) {
                args.add("-f");
            }
        }
        args.add(dest);
        NovacomCommand command = new NovacomCommand(device, cmd, args.toArray(new String[args.size()]));
        try {
            command.run();
        }
        catch (NovacomCommand.NovacomCommandException e) {
            throw new NovacomUtilException(e);
        }
    }

    public static class NovacomNotRespondingException
    extends NovacomUtilException {
        private static final long serialVersionUID = -1407678276087529836L;

        public NovacomNotRespondingException() {
            super("novacom wedged");
        }
    }

    public static class NovacomUtilException
    extends Exception {
        private static final long serialVersionUID = -5664544611671659863L;

        public NovacomUtilException(String message) {
            super(message);
        }

        public NovacomUtilException(Throwable t) {
            super(t);
        }
    }
}

