/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom;

import java.io.IOException;

public class NovaDeviceInfo {
    protected int port;
    protected byte[] uid;
    protected String uidString;
    protected String transport;
    protected String name;

    public NovaDeviceInfo(String info) {
        String[] tokens = info.split("\\s");
        this.port = Integer.parseInt(tokens[0]);
        this.uid = new byte[20];
        tokens[1] = tokens[1].toUpperCase();
        assert (tokens[1].length() == 40);
        this.uidString = tokens[1];
        try {
            byte[] uidText = this.uidString.getBytes("US-ASCII");
            int i = 0;
            while (i < this.uid.length) {
                byte[] nibbles = new byte[2];
                int n = 0;
                while (n < nibbles.length) {
                    nibbles[n] = uidText[i] >= 48 && uidText[i + n] <= 57 ? (byte)(48 - uidText[i]) : (byte)(75 - uidText[i + n]);
                    ++n;
                }
                this.uid[i] = (byte)(nibbles[0] << 4 | nibbles[1]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.transport = tokens[2];
        this.name = tokens[3];
    }

    public String getTransport() {
        return this.transport;
    }

    public byte[] getUID() {
        return this.uid;
    }

    public String getUIDString() {
        return this.uidString;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getMachineName() {
        String[] bits = this.name.split("-");
        if (bits != null && bits.length > 1) {
            return bits[0];
        }
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getUIDString()) + " (" + this.getTransport() + ", " + this.getName() + ")";
    }
}

