/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.tests;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.net.SocketException;

public class BasicTests {
    public static void main(String[] args) {
        block29: {
            System.err.println("Basic Novacom Tests");
            INovacomController controller = Novacom.getController();
            try {
                int code;
                INovacomStream stream;
                NovaDeviceInfo[] devices = controller.getDeviceList();
                int i = 0;
                while (i < devices.length) {
                    System.err.println(devices[i].toString());
                    ++i;
                }
                if (devices.length <= 0) {
                    System.err.println("No Devices, No Tests.");
                    return;
                }
                INovacomDevice device = controller.connectToDevice(devices[0]);
                if (device.getState() == Novacom.DeviceState.BOOTLOADER) {
                    System.err.println("BOOTLOADER Test Run");
                    INovacomStream stream2 = device.runProgram("", null);
                    String command = "usb print ";
                    String call = "Hello World, via NovaCom";
                    String combined = String.valueOf(command) + call;
                    byte[] bytes = combined.getBytes("US-ASCII");
                    stream2.write(bytes);
                    stream2.closeOutput();
                    String reply = stream2.readLine();
                    System.err.print(reply);
                    stream2.close();
                    break block29;
                }
                System.out.println("[test]-----------------------");
                System.err.println("OS Test Run");
                System.err.println("Get a file that doesn't exist.");
                try {
                    stream = device.getFile("/foobar/is/geeky");
                    stream.close();
                }
                catch (NovacomException e) {
                    System.out.println(e);
                }
                System.out.println("[test]-----------------------");
                stream = device.runProgram("/bin/cat", new String[]{"/dev/urandom"});
                int i2 = 0;
                while (i2 < 50) {
                    code = stream.read();
                    System.out.print(" " + code);
                    ++i2;
                }
                System.out.println("");
                stream.sendSignal(2);
                while (stream.read() > 0) {
                    System.out.println("Still alive");
                }
                System.out.println("Got returncode " + stream.waitForReturnCode());
                stream.close();
                System.out.println("[test]-----------------------");
                stream = device.runProgram("/bin/cat", new String[]{"/dev/urandom"});
                i2 = 0;
                while (i2 < 50) {
                    code = stream.read();
                    System.out.print(" " + code);
                    ++i2;
                }
                System.out.println("");
                stream.sendSignal(7);
                while (stream.read() > 0) {
                    System.out.println("Still alive");
                }
                System.out.println("Got returncode " + stream.waitForReturnCode());
                stream.close();
                System.out.println("[test]-----------------------");
                stream = device.putFile("/tmp/hello_world.txt");
                i2 = 0;
                while (i2 < 10) {
                    String hello = "Hello World, via NovaCom :" + i2 + "\n";
                    byte[] bytes = hello.getBytes("US-ASCII");
                    stream.write(bytes);
                    ++i2;
                }
                stream.closeOutput();
                stream.close();
                System.out.println("[test]-----------------------");
                stream = device.getFile("/tmp/hello_world.txt");
                String line = null;
                while ((line = stream.readLine()) != null && line.length() != 0) {
                    System.out.print(line);
                }
                stream.close();
                System.out.println("\n\"return code\" test");
                stream = device.runProgram("/bin/ls", new String[]{"-l /mamba"});
                int retCode = stream.waitForReturnCode();
                if (retCode > 0) {
                    System.out.println("Correct return code " + retCode);
                } else {
                    System.err.println("Incorrect return code!!!");
                }
                System.out.println("[test]-----------------------");
                System.out.println("\n\"Broken pipe\" test");
                stream = device.runProgram("/bin/cat", new String[]{""});
                String hello = "Hello World";
                byte[] bytes = hello.getBytes("US-ASCII");
                int i3 = 0;
                while (i3 < 5) {
                    stream.write(bytes);
                    ++i3;
                }
                stream.sendSignal(7);
                try {
                    i3 = 0;
                    while (i3 < 50000) {
                        stream.write(bytes);
                        Thread.sleep(10L);
                        ++i3;
                    }
                }
                catch (SocketException eS) {
                    System.out.println("exception:");
                    eS.printStackTrace();
                }
                catch (InterruptedException eS) {
                    // empty catch block
                }
                System.out.println("[test]-----------------------");
                System.out.println("connectDevicePort: 5858");
                try {
                    stream = device.connectDevicePort(5858);
                    i = 0;
                    while (i < 5) {
                        line = stream.readLine();
                        System.out.print(line);
                        ++i;
                    }
                    stream.closeOutput();
                    stream.closeInput();
                    stream.close();
                }
                catch (NovacomException e) {
                    System.out.println("unable to connect to device port ");
                    e.printStackTrace();
                }
                System.out.println("[test]-----------------------");
                System.out.println("Exception check on command handling: please DISCONNECT device within 10sec");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!device.isConnected()) {
                    stream = device.getFile("/tmp/hello_world.txt");
                    while ((line = stream.readLine()) != null && line.length() != 0) {
                        System.out.print(line);
                    }
                    stream.close();
                } else {
                    System.out.println("device is connected, skip test...");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NovacomException e) {
                e.printStackTrace();
            }
        }
    }
}

