/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.palm.nova.installer.core.LoggerUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class DesktopDriversMgr {
    static final String NOVACOM_DRIVERS_INSTALLER_WINDOWS_32BIT = "NovacomInstaller_x86.msi";
    static final String NOVACOM_DRIVERS_INSTALLER_WINDOWS_64BIT = "NovacomInstaller_x64.msi";
    static final String NOVACOM_DRIVERS_INSTALLER_RESOURCE_PATH_WINDOWS_32BIT = "/resources/NovacomInstaller_x86.msi";
    static final String NOVACOM_DRIVERS_INSTALLER_RESOURCE_PATH_WINDOWS_64BIT = "/resources/NovacomInstaller_x64.msi";
    static final String NOVACOM_DRIVERS_INSTALLER_MACOSX = "/resources/NovacomInstaller.pkg.tar.gz";
    static final String NOVACOM_DRIVERS_CONFIG_FILE = "/resources/desktopinstallers.config";
    static final String NOVACOM_DRIVERS_WINDOWS_REG = "HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{BA9A297F-0198-4EE8-90CB-F5036C180E1D}";
    static final String NOVACOM_DRIVERS_MAC_PKGVERFILE = "/Library/Receipts/NovacomInstaller.pkg/Contents/Resources/package_version";
    Logger logger = LoggerUtils.getInstance().getLogger(DesktopDriversMgr.class.getName());

    private Integer getInternalPhoenixBuildVersion() {
        Integer foundVersion = 0;
        Properties configFile = new Properties();
        try {
            InputStream is = DesktopDriversMgr.class.getResourceAsStream(NOVACOM_DRIVERS_CONFIG_FILE);
            configFile.load(is);
            foundVersion = Integer.parseInt((String)configFile.get("InstallerVersion"));
            is.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error Reading Internal Version", e);
        }
        return foundVersion;
    }

    private boolean doesMacOsXDriverNeedUpdating() {
        boolean needsUpdating;
        block6: {
            needsUpdating = true;
            String osversion = System.getProperty("os.version");
            this.logger.info("MacOS Version is " + osversion);
            try {
                if (osversion.startsWith("10.6")) {
                    int foundVersion = this.getSnowLeopardNovacomInstallerPkgVersion();
                    if (foundVersion >= this.getInternalPhoenixBuildVersion()) {
                        needsUpdating = false;
                    }
                    break block6;
                }
                BufferedReader macPkgVerFile = new BufferedReader(new FileReader(NOVACOM_DRIVERS_MAC_PKGVERFILE));
                String macPkgVerInFile = macPkgVerFile.readLine();
                if (null != macPkgVerInFile) {
                    int foundVersion = Integer.parseInt(macPkgVerInFile.split(":")[1].trim());
                    if (foundVersion >= this.getInternalPhoenixBuildVersion()) {
                        needsUpdating = false;
                    }
                    macPkgVerFile.close();
                    break block6;
                }
                throw new Exception("Coulnd't read mac package version");
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Couldn't find Novacom so Installing it", e);
            }
        }
        return needsUpdating;
    }

    private boolean is64bitWindows() {
        this.logger.info("+++++is64bitWindows");
        boolean is64bit = false;
        try {
            Process p = Runtime.getRuntime().exec("systeminfo.exe /FO CSV /NH");
            OffloadedStreamReader stdErrRdr = new OffloadedStreamReader(p.getErrorStream(), "Std Error Stream");
            OffloadedStreamReader stdInRdr = new OffloadedStreamReader(p.getInputStream(), "Std Input Stream", "x64-based PC");
            stdErrRdr.start();
            stdInRdr.start();
            int exitValue = p.waitFor();
            this.logger.info("systeminfo.exe query exited with: " + exitValue);
            stdErrRdr.join();
            stdInRdr.join();
            is64bit = null != stdInRdr.getFoundLine();
            this.logger.info("Windows 64 Bit Support Available: " + is64bit);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Couldn't find Novacom so Installing it", e);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "Couldn't find Novacom so Installing it", e);
        }
        this.logger.info("-----is64bitWindows");
        return is64bit;
    }

    private InstallTypeNeeded doesWindowsDriverNeedUpdating() {
        this.logger.info("+++++doesWindowsDriverNeedUpdating");
        InstallTypeNeeded needsUpdating = InstallTypeNeeded.NEW_INSTALL;
        try {
            Process p = Runtime.getRuntime().exec("reg.exe query HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{BA9A297F-0198-4EE8-90CB-F5036C180E1D}");
            OffloadedStreamReader stdErrRdr = new OffloadedStreamReader(p.getErrorStream(), "Std Error Stream");
            OffloadedStreamReader stdInRdr = new OffloadedStreamReader(p.getInputStream(), "Std Input Stream", "DisplayVersion");
            stdErrRdr.start();
            stdInRdr.start();
            int exitValue = p.waitFor();
            this.logger.info("reg.exe query exited with: " + exitValue);
            stdErrRdr.join();
            stdInRdr.join();
            String versionString = stdInRdr.getFoundLine();
            if (null != versionString) {
                versionString = versionString.trim();
                String[] sarray = versionString.split("\\s+");
                String[] varray = sarray[2].split("\\.");
                int length = varray.length;
                needsUpdating = varray[0].equals("1") && this.getInternalPhoenixBuildVersion() <= Integer.parseInt(varray[length - 1]) ? InstallTypeNeeded.NO_INSTALL_NEEDED : InstallTypeNeeded.UPGRADE_INSTALL;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Couldn't find Novacom so Installing it", e);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "Couldn't find Novacom so Installing it", e);
        }
        this.logger.info("-----doesWindowsDriverNeedUpdating");
        return needsUpdating;
    }

    private boolean installMacOsXDrivers() {
        this.logger.info("+++++installMacOsXDrivers");
        boolean returnVal = true;
        String tempDir = System.getProperty("java.io.tmpdir");
        try {
            if (this.doesMacOsXDriverNeedUpdating()) {
                this.logger.info("buffering drivers");
                int BUFFER_SIZE = 2048;
                BufferedOutputStream dest = null;
                InputStream is = DesktopDriversMgr.class.getResourceAsStream(NOVACOM_DRIVERS_INSTALLER_MACOSX);
                GZIPInputStream gis = new GZIPInputStream(is);
                TarInputStream tis = new TarInputStream(gis);
                TarEntry entry = null;
                while ((entry = tis.getNextEntry()) != null) {
                    int count;
                    String entryFn = tempDir + "/" + entry.getName();
                    this.logger.info("Extracting: " + entryFn);
                    byte[] buf = new byte[2048];
                    if (entry.isDirectory()) {
                        File dirFile = new File(entryFn);
                        if (null != dirFile) {
                            if (dirFile.mkdirs()) continue;
                            throw new Exception("Unable to create Directory");
                        }
                        throw new Exception("Unable to create Directory");
                    }
                    File entryFile = new File(entryFn);
                    dest = new BufferedOutputStream(new FileOutputStream(entryFile), 2048);
                    while ((count = tis.read(buf, 0, 2048)) != -1) {
                        dest.write(buf, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    this.execIgnoreOutput("chmod ugoa+x " + entryFn);
                }
                tis.close();
                this.logger.info("installing drivers");
                int exitValue = this.execIgnoreOutput("open -W " + tempDir + "/NovacomInstaller.pkg");
                this.logger.info("Pkg Installer exited with: " + exitValue);
                this.execIgnoreOutput("rm -rf " + tempDir + "/NovacomInstaller.pkg");
            } else {
                this.logger.finer("no need to update Mac OS drivers");
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "IOException", e);
            returnVal = false;
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "InterruptedException", e);
            returnVal = false;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception", e);
            returnVal = false;
        }
        return returnVal;
    }

    private int execIgnoreOutput(String cmd) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(cmd);
        OffloadedStreamReader stdErrRdr = new OffloadedStreamReader(p.getErrorStream(), "Std Error Stream");
        OffloadedStreamReader stdInRdr = new OffloadedStreamReader(p.getInputStream(), "Std Input Stream");
        stdErrRdr.start();
        stdInRdr.start();
        int exitValue = p.waitFor();
        this.logger.info(cmd + " exited with: " + exitValue);
        stdErrRdr.join();
        stdInRdr.join();
        return exitValue;
    }

    private boolean installWindowsDrivers(boolean is64Bit) {
        this.logger.info("+++++installWindowsDrivers");
        String novacomDriver = NOVACOM_DRIVERS_INSTALLER_WINDOWS_32BIT;
        String novacomDriverInResource = NOVACOM_DRIVERS_INSTALLER_RESOURCE_PATH_WINDOWS_32BIT;
        if (is64Bit) {
            novacomDriver = NOVACOM_DRIVERS_INSTALLER_WINDOWS_64BIT;
            novacomDriverInResource = NOVACOM_DRIVERS_INSTALLER_RESOURCE_PATH_WINDOWS_64BIT;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        File novacomInstallerFile = new File(tempDir + "/" + novacomDriver);
        boolean returnVal = true;
        try {
            InstallTypeNeeded installType = this.doesWindowsDriverNeedUpdating();
            if (InstallTypeNeeded.NO_INSTALL_NEEDED != installType) {
                int len;
                this.logger.info("reading in driver to stream");
                FileOutputStream os = new FileOutputStream(novacomInstallerFile);
                InputStream is = DesktopDriversMgr.class.getResourceAsStream(novacomDriverInResource);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    os.write(buf, 0, len);
                }
                is.close();
                os.close();
                int exitValue = 0;
                if (InstallTypeNeeded.NEW_INSTALL == installType) {
                    this.logger.info("New Windows Driver Install");
                    exitValue = this.execIgnoreOutput("msiexec /i " + novacomInstallerFile.getAbsolutePath() + " /passive");
                } else {
                    this.logger.info("Upgrade Windows Driver Install");
                    exitValue = this.execIgnoreOutput("msiexec /i " + novacomInstallerFile.getAbsolutePath() + " REINSTALL=ALL REINSTALLMODE=vomus /norestart /passive");
                }
                this.logger.info("MSIEXED exited with: " + exitValue);
            } else {
                this.logger.info("Windows drivers already up to date");
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "IOException", e);
            returnVal = false;
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "InterruptedException", e);
            returnVal = false;
        }
        this.logger.info("-----installWindowsDrivers");
        return returnVal;
    }

    private boolean installLinuxDrivers() {
        return true;
    }

    private Integer getSnowLeopardNovacomInstallerPkgVersion() {
        Integer version = 0;
        try {
            String[] args = new String[]{"sh", "-c", "pkgutil --pkg-info palm.novaInstaller.macnovainstaller.pkg"};
            Process p = Runtime.getRuntime().exec(args);
            OffloadedStreamReader stdErrRdr = new OffloadedStreamReader(p.getErrorStream(), "Std Error Stream");
            OffloadedStreamReader stdOutRdr = new OffloadedStreamReader(p.getInputStream(), "Std Input Stream", "version");
            stdErrRdr.start();
            stdOutRdr.start();
            int exitValue = p.waitFor();
            this.logger.info("pkgutil query exited with: " + exitValue);
            stdOutRdr.join();
            String versionString = stdOutRdr.getFoundLine();
            this.logger.info("pkgutil query returned " + versionString);
            if (null != versionString) {
                versionString = versionString.trim();
                String[] sarray = versionString.split(" ");
                version = Integer.parseInt(sarray[1]);
                this.logger.info("pkgutil version is " + version);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "couldn't get package info so returning 0 ", e);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "couldn't get package info so returning 0", e);
        }
        return version;
    }

    public boolean checkAndInstallDrivers() {
        boolean returnVal;
        this.logger.info("+++++checkAndInstallDrivers");
        String osName = System.getProperty("os.name").toUpperCase();
        this.logger.info("Java Os Name: " + osName);
        this.logger.info("Java Os Arch: " + System.getProperty("os.arch").toUpperCase());
        this.logger.info("Java Os version: " + System.getProperty("os.version"));
        this.logger.info("java version: " + System.getProperty("java.version"));
        this.logger.info("java home: " + System.getProperty("java.home"));
        this.logger.info("java tmp dir: " + System.getProperty("java.io.tmpdir"));
        this.logger.info("java vendor: " + System.getProperty("java.vendor"));
        this.logger.info("java vm version: " + System.getProperty("java.vm.version"));
        this.logger.info("java vm vendor: " + System.getProperty("java.vm.vendor"));
        this.logger.info("user lang: " + System.getProperty("user.lang"));
        if (osName.contains("WINDOWS")) {
            returnVal = this.installWindowsDrivers(this.is64bitWindows());
        } else if (osName.equals("MAC OS X")) {
            returnVal = this.installMacOsXDrivers();
        } else if (osName.equals("LINUX")) {
            returnVal = this.installLinuxDrivers();
        } else {
            this.logger.warning("Unsupported System");
            returnVal = false;
        }
        this.logger.info("-----checkAndInstallDrivers");
        return returnVal;
    }

    static enum InstallTypeNeeded {
        NEW_INSTALL,
        UPGRADE_INSTALL,
        NO_INSTALL_NEEDED;

    }

    class OffloadedStreamReader
    extends Thread {
        InputStream is;
        String inputType;
        Logger offloadLogger;
        String searchForLine;
        String foundLine;

        OffloadedStreamReader(InputStream is, String inputType, String searchForLine) {
            this.is = is;
            this.inputType = inputType;
            this.foundLine = null;
            this.searchForLine = searchForLine;
            this.offloadLogger = LoggerUtils.getInstance().getLogger(OffloadedStreamReader.class.getName());
        }

        OffloadedStreamReader(InputStream is, String inputType) {
            this(is, inputType, null);
        }

        @Override
        public void run() {
            try {
                String s;
                BufferedReader stream = new BufferedReader(new InputStreamReader(this.is));
                this.offloadLogger.info("Here is " + this.inputType + " output of the command:\n");
                while ((s = stream.readLine()) != null) {
                    this.offloadLogger.info(s);
                    if (null == this.searchForLine || !s.contains(this.searchForLine)) continue;
                    this.foundLine = s;
                }
                this.is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public String getFoundLine() {
            return this.foundLine;
        }
    }
}

