/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class RestoreLogsAfterFlashStage
extends BaseStage {
    private static final String RUNNER_NAME = "RestoreLogsAfterFlash";
    private static final String RM = "/bin/rm";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TEMP_MEDIAFS = "/tmp_media";
    private static final String TEMP_VAR = "/tmp_var";
    private static final String RESTORE_LOGS = "/usr/local/sbin/recovery/restore_logs.sh";
    private static final String WOD_LOGS = "PalmWebOsRecoveryToolLog";
    private final INovacomDevice device;
    private Object jobId;

    public RestoreLogsAfterFlashStage(INovacomDevice device) {
        this.device = device;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "restoring logs after flashing ");
        this.runCommand(RM, new String[]{"-rf", TEMP_MEDIAFS});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_MEDIAFS});
        this.runCommand(RM, new String[]{"-rf", TEMP_VAR});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_VAR});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.MEDIAFS, MountUtils.FsType.VFAT, TEMP_MEDIAFS);
        mountUtils.mount(MountUtils.MountParts.VARFS, MountUtils.FsType.EXT3, TEMP_VAR);
        reporter.commentOnJob(this.jobId, "mounted mediafs and varfs sucessfully");
        INovacomStream stream = this.device.runProgram(RESTORE_LOGS, new String[0]);
        stream.flush();
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            reporter.commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        stream.flush();
        int retCode = stream.waitForReturnCode();
        stream.close();
        if (retCode == 0) {
            StringBuffer script = new StringBuffer("start on stopped finish\n");
            script.append("script\n");
            script.append("  if [ -f /var/wod_logs.tar.gz ]; then\n");
            script.append("    if [ -x /usr/bin/rdx_reporter ]; then\n");
            script.append("      /usr/bin/rdx_reporter -C 'wod' -c 'wod' -d 'wod' -f /var/wod_logs.tar.gz -p wods_logs.tar.gz\n");
            script.append("      /bin/rm -f /var/wod_logs.tar.gz\n");
            script.append("    else if [ -d /var/misc ]; then\n");
            script.append("      mv /var/wod_logs.tar.gz /var/misc/wod\n");
            script.append("    fi\n");
            script.append("    fi\n");
            script.append("  fi\n");
            script.append("end script");
            this.runCommand(MKDIR, new String[]{"-p", "/tmp_var/palm/event.d"});
            try {
                stream = this.device.putFile("/tmp_var/palm/event.d/uploadLog");
            }
            catch (IOException e) {
                reporter.commentOnJob(this.jobId, "Eating IOException when creating uploadLog file");
            }
            catch (NovacomException e) {
                reporter.commentOnJob(this.jobId, "Eating NovacomException when creating uploadLog file");
            }
            stream.write(script.toString().getBytes("US-ASCII"));
            stream.closeInput();
            stream.closeOutput();
            if (stream.waitForReturnCode() != 0) {
                reporter.commentOnJob(this.jobId, "WARNING:: Issue with creating uploadLog script in /var/palm/event.d ");
            }
            stream.close();
        } else {
            reporter.commentOnJob(this.jobId, "WARNING:: Issue with restoring logs");
        }
        reporter.commentOnJob(this.jobId, "Done with RestoreLogs stage");
        mountUtils.umount(MountUtils.MountParts.MEDIAFS);
        mountUtils.umount(MountUtils.MountParts.VARFS);
        reporter.endJob(this.jobId);
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream, true);
    }

    private void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

