/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.ResourceInTarInstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class SideloadStage
extends BaseStage {
    private static final String RUNNER_NAME = "Sideload";
    private static final String MKDIR = "/bin/mkdir";
    private static final String RM = "/bin/rm";
    private static final String TAR = "/bin/tar";
    private static final String TEMP_VARFS = "/tmp_varfs";
    private static final String TEMP_DIR = "/tmp/sideload";
    private final INovacomDevice device;
    private Object jobId;
    private final ResourceInTarInstallerModel installerModel;

    public SideloadStage(INovacomDevice device, ResourceInTarInstallerModel model) {
        this.device = device;
        this.installerModel = model;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "flashing sideload file ");
        this.runCommand(RM, new String[]{"-rf", TEMP_DIR});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_DIR});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.VARFS, MountUtils.FsType.EXT3, TEMP_VARFS);
        InputStream tis = this.installerModel.getResourceInputStream();
        String fileOnDevice = "/tmp/sideload/" + this.installerModel.getResourceTarEntry();
        this.putFile(tis, fileOnDevice);
        tis.close();
        this.runCommand(TAR, new String[]{"xzf", fileOnDevice, "-C", TEMP_VARFS});
        reporter.commentOnJob(this.jobId, "sideload file flashed ");
        mountUtils.umount(MountUtils.MountParts.VARFS);
        reporter.endJob(this.jobId);
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream, true);
    }

    private void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }

    private void putFile(InputStream fileStream, String filePathOnDevice) {
        if (fileStream == null) {
            throw new IllegalArgumentException("fileStream is null!");
        }
        try {
            INovacomStream outputStream = this.device.putFile(filePathOnDevice);
            long written = outputStream.write(fileStream);
            System.out.println("written " + written);
            outputStream.closeOutput();
            outputStream.waitForReturnCode();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getProgressHandler().commentOnJob(null, e.getMessage());
            LoggerUtils.getInstance().getLogger("SideloadStage").log(Level.WARNING, "", e);
        }
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

