/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class SoftwareUpdateSiteStage
extends BaseStage {
    private static final String OMADIR = "/usr/share/omadm/";
    private static final String TEMP_ROOTFS = "/tmp_rootfs";
    private static final String TEMP_VARFS = "/tmp_varfs";
    private static final String TEMP_LOGFS = "/tmp_logfs";
    private static final String RUNNER_NAME = "Software Update Site Stage";
    private static final String MKDIR = "/bin/mkdir";
    private static final String LOG_PATH = "/";
    private static final String LOG_FILE = "ndi_settings.log";
    private boolean isSupported = true;
    private final INovacomDevice device;
    private Object jobId;
    private final String siteFileName;
    private final String siteUrl;
    private String siteLabel;

    public SoftwareUpdateSiteStage(INovacomDevice device, String siteFileName, String siteUrl) throws NovacomException {
        this.siteFileName = siteFileName;
        if (null == siteFileName || 0 == siteFileName.length()) {
            throw new NovacomException(-1, "SiteName not given");
        }
        if (null == siteUrl || 0 == siteUrl.length()) {
            throw new NovacomException(-1, "Site Url not given");
        }
        this.siteUrl = siteUrl;
        this.device = device;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        System.out.println("about to instance mount");
        MountUtils mountUtils = new MountUtils(this.device);
        System.out.println("about to mount");
        mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TEMP_ROOTFS);
        System.out.println("moving to set URL");
        this.getProgressHandler().commentOnJob(this.jobId, "Setting software update site to \"" + this.siteFileName + "\"");
        this.runCommand(MKDIR, new String[]{"-p", "/tmp_rootfs/usr/share/omadm/"});
        String siteFullPathAndName = "/tmp_rootfs/usr/share/omadm/" + this.siteFileName;
        INovacomStream stream = this.device.putFile(siteFullPathAndName);
        stream.write(this.siteUrl.getBytes("US-ASCII"));
        stream.closeOutput();
        stream.close();
        stream = this.device.getFile(siteFullPathAndName);
        String verifyString = stream.readLine();
        stream.closeInput();
        stream.close();
        if (verifyString == null || !verifyString.equals(this.siteUrl)) {
            reporter.commentOnJob(this.jobId, "sleeping and trying to verify urlString again");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                reporter.commentOnJob(this.jobId, "sleep interupted");
            }
            stream = this.device.getFile(siteFullPathAndName);
            verifyString = stream.readLine();
            stream.closeInput();
            stream.close();
            if (verifyString == null || !verifyString.equals(this.siteUrl)) {
                reporter.commentOnJob(this.jobId, "FAILED to write Software update URL");
                throw new NovacomException(-1, "FAILED to write Software update URL");
            }
            reporter.commentOnJob(this.jobId, "Verified Software Update URL");
        } else {
            reporter.commentOnJob(this.jobId, "Verified Software Update URL");
        }
        if (!this.isSupported) {
            mountUtils.mount(MountUtils.MountParts.LOGFS, MountUtils.FsType.EXT3, TEMP_LOGFS);
            this.runCommand(MKDIR, new String[]{"-p", "/tmp_logfs/"});
            StringBuffer script = new StringBuffer("#!/bin/sh\n/bin/echo WARNING: unsupported update site selected >> /tmp_logfs/ndi_settings.log\n");
            script.append("/bin/echo label is " + this.siteLabel + " >>" + TEMP_LOGFS + LOG_PATH + LOG_FILE + "\n");
            script.append("/bin/echo url is " + this.siteUrl + " >>" + TEMP_LOGFS + LOG_PATH + LOG_FILE + "\n");
            script.append("/bin/echo file name is /usr/share/omadm/" + this.siteFileName + " >>" + TEMP_LOGFS + LOG_PATH + LOG_FILE + "\n");
            script.append("/bin/echo search https://wiki.palm.com/display/systemsoftware/Troubleshoot+flashing+problems+with+NDI for CWS-902 >>/tmp_logfs/ndi_settings.log\n");
            script.append("\nexit 0\n");
            INovacomStream output = this.device.putFile("/tmp/writelogfile.sh");
            output.write(script.toString().getBytes("US-ASCII"));
            output.closeInput();
            output.closeOutput();
            output.waitForReturnCode();
            output.close();
            output = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/writelogfile.sh"});
            output.close();
            mountUtils.umount(MountUtils.MountParts.LOGFS);
        }
        mountUtils.umount(MountUtils.MountParts.ROOTFS);
        reporter.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    public void setSupported(boolean support) {
        this.isSupported = support;
    }

    public void setLabel(String str) {
        this.siteLabel = str;
    }

    private String runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        return this.printStreamToProgressReporter(stream);
    }

    private String printStreamToProgressReporter(INovacomStream stream) throws IOException, NovacomException {
        return this.printStreamToProgressReporter(stream, true);
    }

    private String printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        StringBuffer returnVal = new StringBuffer();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            returnVal.append(line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
        return returnVal.toString();
    }
}

