/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.palm.nova.installer.core.FlasherThread;
import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.TarInJarInstallerModel;
import com.palm.nova.installer.core.TarfileInstallerModel;
import com.palm.nova.installer.core.TarredInstallerModel;
import com.palm.nova.installer.recoverytool.Base64;
import com.palm.nova.installer.recoverytool.ConfigFileMgr;
import com.palm.nova.installer.recoverytool.runner.DeviceDiscoveryRunner;
import com.palm.nova.installer.recoverytool.runner.RunnerCallback;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovacomException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class MainFlasher
implements RunnerCallback {
    static final int RUNNER_ID_DEVICE_DISCOVERY = 1;
    static final int NUM_SECONDS_WAIT_DEVICE = 5;
    private FlasherThread flashRunner = null;
    private Logger logger = null;
    private INovacomDevice device = null;
    DeviceDiscoveryRunner deviceDiscoveryRunner;
    IFlasherLogger flashEventHandler;

    public MainFlasher(IFlasherLogger theHandler) {
        this.flashEventHandler = theHandler;
        this.logger = Logger.getLogger("com.palm.recoverytool");
        this.logger.info("+++++MainFlasher");
        this.deviceDiscoveryRunner = new DeviceDiscoveryRunner(this, 1);
        this.deviceDiscoveryRunner.setTimeout(5000L);
        this.deviceDiscoveryRunner.start();
        try {
            int count = 0;
            while (null == this.device && count < 5) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            this.logger.info("warning - did not wait for device as expected");
        }
    }

    public int configureFlasherThread() throws FileNotFoundException, IOException {
        TarEntry te;
        TarInputStream ts;
        byte[] bits;
        if (null == this.device) {
            this.logger.severe("cannot configure flasher, no device found");
            return -1;
        }
        this.logger.info("Start time " + System.currentTimeMillis());
        this.logger.info("looking for /resources/" + ConfigFileMgr.getInstance().getBaseBuildFilename());
        InputStream inStream = this.getClass().getResourceAsStream("/resources/" + ConfigFileMgr.getInstance().getBaseBuildFilename());
        String baseFullPathAndName = null;
        String custFullPathAndName = null;
        String prevBaseFullPathAndName = null;
        String prevCustFullPathAndName = null;
        String sri = ConfigFileMgr.getInstance().getApprovalReleaseHash();
        String carrier = ConfigFileMgr.getInstance().getApprovalCharlieHash();
        String model = ConfigFileMgr.getInstance().getApprovalMikeHash();
        String deviceType = ConfigFileMgr.getInstance().getDeviceType();
        String carrierList = null;
        String modelList = null;
        String buildNumber = ConfigFileMgr.getInstance().getBuildNumber();
        String prodFile = ConfigFileMgr.getInstance().getApprovalBuildName();
        TarredInstallerModel baseModel = null;
        TarredInstallerModel custModel = null;
        TarInJarInstallerModel prevBaseModel = null;
        TarInJarInstallerModel prevCustModel = null;
        String baseBuildFileName = ConfigFileMgr.getInstance().getBaseBuildFilename();
        String custBuildFileName = ConfigFileMgr.getInstance().getCustomizationFileName();
        String prevBaseBuildFileName = ConfigFileMgr.getInstance().getPrevBaseBuildFilename();
        String prevCustBuildFileName = ConfigFileMgr.getInstance().getPrevCustomizationFileName();
        URL dir = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        this.logger.info(this.getClass().getName() + " is loaded from: " + dir);
        File jarFile = new File(dir.getFile());
        this.logger.info("jarFile path is: " + jarFile);
        if (jarFile.isDirectory()) {
            this.logger.warning("not running from jar");
        }
        baseFullPathAndName = jarFile.getParent() + "/" + baseBuildFileName;
        custFullPathAndName = jarFile.getParent() + "/" + custBuildFileName;
        this.logger.info("full path of the baseBuild file outside jar is: " + baseFullPathAndName);
        this.logger.info("full path of the customizationBuild file outside jar is: " + custFullPathAndName);
        if (new File(baseFullPathAndName).exists() && new File(custFullPathAndName).exists()) {
            this.logger.info("Loading the base tar from outside the jar with path: " + baseFullPathAndName);
            this.logger.info("Loading the customization tar from outside the jar with path: " + custFullPathAndName);
            baseModel = new TarfileInstallerModel(new File(baseFullPathAndName));
            custModel = new TarfileInstallerModel(new File(custFullPathAndName));
            this.logger.info("no issues loading baseModel or custModel Tarfiles outside the jar");
        } else if (inStream != null) {
            this.logger.info("found resource in jar");
            baseFullPathAndName = "/resources/" + baseBuildFileName;
            baseModel = new TarInJarInstallerModel(baseFullPathAndName);
            this.logger.info("Base build file found inside jar and loaded sucessfully");
            if (custBuildFileName != null && custBuildFileName.length() > 0) {
                custFullPathAndName = "/resources/" + custBuildFileName;
                custModel = new TarInJarInstallerModel(custFullPathAndName);
                this.logger.info("Customization build file found inside jar and loaded sucessfully");
            } else {
                custModel = null;
            }
            if (prevBaseBuildFileName != null && prevBaseBuildFileName.length() > 0) {
                prevBaseFullPathAndName = "/resources/" + prevBaseBuildFileName;
                prevBaseModel = new TarInJarInstallerModel(prevBaseFullPathAndName);
            }
            if (prevCustBuildFileName != null && prevCustBuildFileName.length() > 0) {
                prevCustFullPathAndName = "/resources/" + prevCustBuildFileName;
                prevCustModel = new TarInJarInstallerModel(prevCustFullPathAndName);
            }
        } else if (inStream == null || !new File(baseFullPathAndName).exists() || !new File(custFullPathAndName).exists()) {
            this.logger.warning("Could not find base and customization tar files inside or next to the jar file");
            throw new FileNotFoundException("Failed to find base/customization build files");
        }
        if (null != sri) {
            bits = Base64.decode(sri.getBytes("US-ASCII"));
            if (null != bits) {
                ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)));
                te = ts.getNextEntry();
                if (null != te) {
                    sri = te.getName();
                }
            } else {
                sri = null;
            }
        }
        if (null != prodFile) {
            bits = Base64.decode(prodFile.getBytes("US-ASCII"));
            if (null != bits) {
                ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)));
                te = ts.getNextEntry();
                if (null != te) {
                    prodFile = te.getName();
                }
            } else {
                prodFile = null;
            }
        }
        this.flashRunner = new FlasherThread(baseModel, custModel);
        if (null != carrier && null != (bits = Base64.decode(carrier.getBytes("US-ASCII"))) && null != (te = (ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)))).getNextEntry()) && (carrier = te.getName()).endsWith("txt")) {
            carrierList = MainFlasher.readInputStreamAsString(ts);
            carrierList = carrierList.replaceAll("\n", "");
            this.flashRunner.setCarrierList(carrierList.toLowerCase());
        }
        if (null != model && null != (bits = Base64.decode(model.getBytes("US-ASCII"))) && null != (te = (ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)))).getNextEntry()) && (model = te.getName()).endsWith("txt")) {
            modelList = MainFlasher.readInputStreamAsString(ts);
            modelList = modelList.replaceAll("\n", "");
            this.flashRunner.setModelList(modelList.toLowerCase());
        }
        this.flashRunner.setDeviceType(deviceType.toLowerCase());
        this.flashRunner.setDomName(sri);
        this.flashRunner.setProdFile(prodFile);
        if (null != sri && null != ConfigFileMgr.getInstance().getSoftwareUpdateSite()) {
            StringBuilder url = new StringBuilder("https://");
            url.append("mypretty@golum.");
            url.append("palm.com/location-dir/getdomain/");
            this.flashRunner.setSoftwareUpdateSite(ConfigFileMgr.getInstance().getSoftwareUpdateSite(), url.toString().replace("mypretty@golum", sri));
        }
        this.flashRunner.doVerifyRom(true);
        this.flashRunner.doForceModemUpdate(ConfigFileMgr.getInstance().doForceModemUpdate());
        this.flashRunner.docheckCloud(ConfigFileMgr.getInstance().doCloudCheck());
        this.flashRunner.doSaveMsmPartition(true);
        this.flashRunner.setDevice(this.device);
        this.flashRunner.setMainWindow(this.flashEventHandler);
        this.flashRunner.doVerifyRfsSize(true);
        this.flashRunner.setBuildNumber(buildNumber);
        this.flashRunner.setDelAppDir(true);
        this.flashRunner.setCheckFlash(false);
        this.flashRunner.setSaveLogsStage(true);
        this.flashRunner.setRestoreLogsStage(true);
        this.flashRunner.setDataMigrationStages(true);
        if (prevCustModel != null && prevBaseModel != null) {
            this.flashRunner.setPrevBaseAndCust(prevBaseModel, prevCustModel);
        }
        return 1;
    }

    public Thread runFlasherThread() throws IOException, NovacomException {
        if (null == this.flashRunner) {
            this.logger.severe("flasherThread not initialized, cannot continue");
        }
        Thread thread = new Thread(this.flashRunner);
        thread.start();
        return thread;
    }

    public FlasherThread getFlasherThread() {
        return this.flashRunner;
    }

    public static String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    @Override
    public void runnerHasUpdate(int id, Object o) {
        switch (id) {
            case 1: {
                break;
            }
        }
    }

    @Override
    public void runnerFinished(int id) {
        switch (id) {
            case 1: {
                this.logger.info("device runner done");
                this.device = this.deviceDiscoveryRunner.getResult();
                break;
            }
        }
    }
}

