/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerUtils {
    public static final String NOVACOM_VERSION = "$HeadURL: http://subversion.palm.com/main/nova/palm/com.palm.nova.installer.core/submissions/149/src/com/palm/nova/installer/core/LoggerUtils.java $";
    private static LoggerUtils singletonInstance = null;
    private static Level logLevel = null;
    static int maxLogs = 40;
    Logger globalLogger = null;
    private static final NumberFormat formatter = NumberFormat.getIntegerInstance();

    private LoggerUtils() {
    }

    public static LoggerUtils getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new LoggerUtils();
        }
        return singletonInstance;
    }

    public void setGlobalLogger(Logger logger) {
        this.globalLogger = logger;
    }

    public static void setLevel(Level level) {
        logLevel = level;
    }

    public Logger getLogger(String name) {
        if (this.globalLogger == null) {
            Logger logger = Logger.getLogger(name);
            if (logLevel != null) {
                logger.setLevel(logLevel);
            }
            return logger;
        }
        return this.globalLogger;
    }

    public static void setMaxLogs(int maxLogs) {
        LoggerUtils.maxLogs = maxLogs;
    }

    public static File chooseFile(final String basename) throws IOException {
        final int nameLen = basename.length();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String[] logs = tmpDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File d, String f) {
                return f.startsWith(basename);
            }
        });
        int count = 0;
        if (logs.length > 0) {
            for (String name : logs) {
                int n = LoggerUtils.atoi(name.substring(nameLen));
                if (n < count) continue;
                count = n + 1;
            }
            if (logs.length > maxLogs) {
                Arrays.sort(logs, new Comparator<String>(){

                    @Override
                    public int compare(String n1, String n2) {
                        int i1 = LoggerUtils.atoi(n1.substring(nameLen));
                        int i2 = LoggerUtils.atoi(n2.substring(nameLen));
                        return i1 - i2;
                    }
                });
                for (int i = 0; i < logs.length - maxLogs; ++i) {
                    new File(tmpDir, logs[i]).delete();
                }
            }
        }
        String filename = String.format("%s%d.log", basename, count);
        File logFile = new File(tmpDir, filename);
        logFile.createNewFile();
        return logFile;
    }

    private static final int atoi(String s) {
        try {
            return formatter.parse(s).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static class NDIFormatter
    extends Formatter {
        DateFormat fmt = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");

        @Override
        public String format(LogRecord record) {
            return this.fmt.format(record.getMillis()) + " " + record.getLevel().toString() + " " + record.getMessage() + "\n";
        }
    }

    public static class NDIConsoleHandler
    extends ConsoleHandler {
        private static final int IINFO = Level.INFO.intValue();

        public NDIConsoleHandler() {
            this.setLevel(Level.INFO);
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel().intValue() < this.getLevel().intValue()) {
                return;
            }
            if (record.getLevel().intValue() <= IINFO) {
                System.err.println(record.getMessage());
            } else {
                System.err.println(record.getLevel() + ": " + record.getMessage());
            }
            System.err.flush();
        }
    }
}

