/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.FlasherThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class UpgradePopupWindow
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 0L;
    final String upgrade = "    Continue Upgrade    ";
    final String restore = "Restore Previous Version";
    JPanel panels;
    JButton upgradeButton;
    JButton restoreButton;
    JTextArea Message;
    JFrame newFrame;
    FlasherThread flash;

    protected JTextArea addText(String text, boolean visible, int fontStyle) {
        JTextArea textArea = new JTextArea(text);
        textArea.setFont(new Font("SansSerif", fontStyle, 12));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setBackground(Color.DARK_GRAY);
        textArea.setForeground(Color.WHITE);
        textArea.setOpaque(false);
        textArea.setVisible(visible);
        textArea.setAlignmentX(0.5f);
        this.add(textArea);
        return textArea;
    }

    protected JTextArea addMultiLineLabel(String text, int fontStyle, int fontSize, Object constraints) {
        JTextArea textArea = new JTextArea(text);
        textArea.setFont(new Font("SansSerif", fontStyle, fontSize));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setBackground(new Color(100, 200, 0, 0));
        textArea.setOpaque(false);
        textArea.setBorder(new TitledBorder(""));
        textArea.setAlignmentX(0.5f);
        this.add((Component)textArea, constraints);
        return textArea;
    }

    private UpgradePopupWindow(JFrame frame, Object ft) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.flash = (FlasherThread)ft;
        String text = "An error occurred during the attempt to update your phone's software. We recommend the following: (1) Restore your phone to its previous webOS version, (2) back up important data, and then (3) try updating your phone again. If you continue with the current update, only your previously backed-up data will be available.";
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.addMultiLineLabel(text, 0, 12, gbc);
        this.addFiller(20);
        this.newFrame = frame;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.upgradeButton = new JButton("    Continue Upgrade    ");
        this.upgradeButton.setActionCommand("upgrade");
        this.upgradeButton.addActionListener(this);
        this.upgradeButton.setEnabled(true);
        this.upgradeButton.setBackground(Color.WHITE);
        this.upgradeButton.setForeground(Color.GRAY);
        this.add((Component)this.upgradeButton, gbc);
        ++gbc.gridx;
        this.restoreButton = new JButton("Restore Previous Version");
        this.restoreButton.setActionCommand("restore");
        this.restoreButton.addActionListener(this);
        this.restoreButton.setEnabled(true);
        this.restoreButton.setBackground(Color.DARK_GRAY);
        this.add((Component)this.restoreButton, gbc);
        this.setOpaque(true);
        this.newFrame.setContentPane(this);
    }

    protected void addFiller(int size) {
        Dimension diminsion = new Dimension(size, size);
        Box.Filler filler = new Box.Filler(diminsion, diminsion, diminsion);
        filler.setAlignmentX(0.5f);
        this.add(filler);
    }

    public static void createGUI(Object obj) {
        JFrame frame = new JFrame("Palm(R) webOS(tm) Doctor");
        frame.setDefaultCloseOperation(3);
        frame.setPreferredSize(new Dimension(440, 180));
        UpgradePopupWindow popUpContentPane = new UpgradePopupWindow(frame, obj);
        popUpContentPane.setOpaque(true);
        frame.setContentPane(popUpContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("restore".equals(e.getActionCommand())) {
            System.out.println("restore button selected");
            this.flash.setUpgradeRestoreChoice("restore");
            this.newFrame.dispose();
        } else if ("upgrade".equals(e.getActionCommand())) {
            System.out.println("upgrade button selected");
            this.flash.setUpgradeRestoreChoice("upgrade");
            this.newFrame.dispose();
        }
    }
}

