/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.FlasherThread;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class DataPreCheckStage
extends BaseStage {
    private static final String RUNNER_NAME = "DataPreCheckStage";
    private static final String PRE_CHECK = "/usr/local/sbin/recovery/pre_check.sh";
    private static final String CLEANUP_SCRIPT = "/usr/local/sbin/recovery/cleanup_script.sh";
    private static final int timeOut = 30000;
    private boolean stageFail = false;
    private String pid = null;
    private static final String EOF = new String();
    private final SynchronousQueue<String> pipe = new SynchronousQueue();
    INovacomStream stream;
    private FlasherThread flasher;

    public DataPreCheckStage(INovacomDevice device) {
        super(device);
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        if (!this.device.checkFile(PRE_CHECK)) {
            reporter.commentOnJob(this.jobId, "No recovery utilities for this device.. not saving data");
            reporter.endJob(this.jobId);
            return;
        }
        reporter.commentOnJob(this.jobId, "running pre-checks for data migration");
        this.stream = this.device.runProgram(PRE_CHECK, new String[0]);
        this.stream.flush();
        try {
            String line;
            Consumer t = new Consumer();
            t.start();
            while ((line = this.pipe.poll(30000L, TimeUnit.MILLISECONDS)) != EOF) {
                if (line == null) {
                    reporter.commentOnJob(this.jobId, "no status updates within the 30sec window, closing stream and exiting stage!!");
                    t.interrupt();
                    this.stageFail = true;
                    break;
                }
                if (line.contains("pid is")) {
                    String[] vars = line.split(" ");
                    this.pid = vars[2];
                }
                reporter.commentOnJob(this.jobId, line);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
        this.stream.flush();
        if (this.stageFail) {
            this.killProcessAndCleanup(this.pid);
            reporter.commentOnJob(this.jobId, "stageFail true");
        } else {
            String msg;
            int retCode = this.stream.waitForReturnCode();
            if (retCode == 0) {
                this.flasher.retCodeFromPreCheck(true);
                reporter.commentOnJob(this.jobId, "DataPreCheck stage completed sucessfully!");
            } else if (retCode == 1) {
                msg = "INFO:: Pre-check stage did not detect any restorable data. ReturnCode is: " + retCode;
                reporter.commentOnJob(this.jobId, msg);
            } else {
                if (retCode == 2) {
                    msg = "WARNING:: Issue with PreCheck stage. ReturnCode is: " + retCode;
                    reporter.commentOnJob(this.jobId, msg);
                    throw new NovacomException(-1, "MIGRATION ERROR: failure in preCheck stage");
                }
                if (retCode == 3) {
                    msg = "WARNING:: Issue with PreCheck stage. ReturnCode is: " + retCode;
                    reporter.commentOnJob(this.jobId, msg);
                    throw new NovacomException(-1, "MIGRATION ERROR: failure in preCheck stage");
                }
            }
        }
        this.stream.close();
        reporter.commentOnJob(this.jobId, "Done with DataPreCheck stage");
        reporter.endJob(this.jobId);
    }

    public void setFlasher(FlasherThread ft) {
        this.flasher = ft;
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    private void killProcessAndCleanup(String pid) {
        IStageProgressReporter reporter = this.getProgressHandler();
        try {
            INovacomStream stream = this.device.runProgram(CLEANUP_SCRIPT, new String[]{pid});
            stream.flush();
            String line = stream.readLine();
            while (line.compareTo("") != 0) {
                reporter.commentOnJob(this.jobId, line);
                line = stream.readLine();
            }
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
        }
        catch (NovacomException novacomException) {
            // empty catch block
        }
    }

    private class Consumer
    extends Thread {
        Consumer() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            IStageProgressReporter reporter = DataPreCheckStage.this.getProgressHandler();
            while (!Thread.interrupted()) {
                String line = null;
                try {
                    line = DataPreCheckStage.this.stream.readLine();
                }
                catch (IOException ex) {
                    if (DataPreCheckStage.this.stageFail) {
                        reporter.commentOnJob(DataPreCheckStage.this.jobId, "Swallowing the readline IOexception when time has expired!!");
                    }
                    throw new RuntimeException(ex);
                }
                try {
                    if (line == null || line.length() == 0) {
                        DataPreCheckStage.this.pipe.put(EOF);
                        break;
                    }
                    DataPreCheckStage.this.pipe.put(line);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
    }
}

