/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.DeviceInfo;
import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.ModemUtilities;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;

public class ModemUpdateStage
extends BaseStage
implements IInstallerStage {
    public static final String MODEM_UPDATER = "/usr/bin/PmModemUpdater";
    public static final String MODEM_POWER = "/usr/bin/pmmodempower";
    private final InstallerModel model;
    private boolean forceUpdate = false;
    private ModemUtilities modemUtils;
    private static final int GATHER_DEVICE_DETAILS = 10;
    private static final int MODEM_UTILS = 5;
    private static final int GET_FIRMWARE = 5;
    private static final int START_MODEM_UPDATER = 10;
    private static final int PUSH_FIRMWARE_TO_DEVICE = 30;
    private int currentPercentage = 0;

    public ModemUpdateStage(InstallerModel model, INovacomDevice device) throws IOException, NovacomException {
        super(device);
        this.model = model;
    }

    public void setForceUpdate(boolean state) {
        this.forceUpdate = state;
    }

    @Override
    public String toString() {
        return "Modem Updater";
    }

    private void updatePercentage(IStageProgressReporter progress, Object jobId, int add) {
        this.currentPercentage += add;
        progress.updateJob(jobId, this.currentPercentage);
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob("Modem Updater", 100);
        this.progress.commentOnJob(this.jobId, "Modem Update Started");
        this.progress.commentOnJob(this.jobId, "Gathering device details...");
        if (!this.device.checkFile(MODEM_UPDATER)) {
            this.progress.commentOnJob(this.jobId, "No modem update for this device");
            this.progress.endJob(this.jobId);
            return;
        }
        if (!new DeviceInfo(this.device).hasAModem()) {
            this.progress.commentOnJob(this.jobId, "This device does not have a modem.");
            this.progress.endJob(this.jobId);
            return;
        }
        this.updatePercentage(this.progress, this.jobId, 10);
        this.modemUtils = new ModemUtilities(this.device);
        this.updatePercentage(this.progress, this.jobId, 5);
        String modemType = this.modemUtils.getModemVendor();
        InputStream firmware = this.model.getModemUpdaterFileStream(modemType);
        this.updatePercentage(this.progress, this.jobId, 5);
        if (firmware == null) {
            this.progress.commentOnJob(this.jobId, "ERROR: Unable to get firmware for modem type " + modemType + ", cannot flash modem.");
            this.progress.endJob(this.jobId);
            return;
        }
        String[] args = new String[]{"-o"};
        if (this.forceUpdate) {
            this.progress.commentOnJob(this.jobId, "Forcing modem update, no matter the version.");
            args = new String[]{"-o", "-f"};
        }
        INovacomStream stream = this.device.runProgram(MODEM_UPDATER, args);
        this.updatePercentage(this.progress, this.jobId, 10);
        BaseStage.StreamReaderThread thread = new BaseStage.StreamReaderThread(stream, this.jobId, "$ Your device is ready for use");
        thread.start();
        this.progress.commentOnJob(this.jobId, "Modem Type: " + modemType);
        this.progress.commentOnJob(this.jobId, "Pushing Firmware to Modem Updater");
        stream.write(firmware);
        stream.closeOutput();
        this.updatePercentage(this.progress, this.jobId, 30);
        try {
            this.progress.commentOnJob(this.jobId, "Waiting....");
            thread.join();
            this.progress.commentOnJob(this.jobId, "Finished!");
            if (!thread.didWeFindTheStringWeWereLookingFor()) {
                this.progress.endJob(this.jobId);
                throw new NovacomException(-1, 45, "Error Updating Modem Firmware!!!");
            }
        }
        catch (InterruptedException e) {
            this.progress.endJob(this.jobId);
            throw new IOException("Reader thread never completed.");
        }
        stream.close();
        this.progress.endJob(this.jobId);
    }
}

