/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.recoverytool.MainFlasher;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CmdLineInterface
implements IFlasherLogger {
    Logger logger = LoggerUtils.getInstance().getLogger("CmdLineInterface");
    private boolean goBackFlag = false;

    public CmdLineInterface(boolean goBack) {
        this.goBackFlag = goBack;
        try {
            MainFlasher mainFlasher = new MainFlasher(this);
            mainFlasher.configureFlasherThread();
            mainFlasher.getFlasherThread().setDeveloperMode("novacom_enable");
            mainFlasher.getFlasherThread().setCheckFlash(false);
            mainFlasher.getFlasherThread().setSaveLogsStage(false);
            mainFlasher.getFlasherThread().setRestoreLogsStage(false);
            mainFlasher.getFlasherThread().setCmdLineModeFlag(true);
            if (this.goBackFlag) {
                mainFlasher.getFlasherThread().setGoBackFlag(true);
            }
            mainFlasher.getFlasherThread().setDataMigrationStages(true);
            mainFlasher.getFlasherThread().setLoadRamdisk(false);
            Thread thread = mainFlasher.runFlasherThread();
            thread.join();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "", e);
            this.logger.warning("ioexception setting up flash");
            System.err.println("XXX FATAL XXX " + e.toString());
            System.exit(2);
        }
        catch (NovacomException e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "", e);
            this.logger.warning("novacom exception setting up flash");
            System.err.println("XXX FATAL XXX " + e.toString());
            System.exit(2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "", e);
            this.logger.warning("interrupted exception while flashing");
            System.err.println("XXX FATAL XXX " + e.toString());
            System.exit(2);
        }
    }

    @Override
    public void logPrint(String data) {
        this.logger.info(data);
    }

    @Override
    public void logPrintln(String data) {
        this.logPrint(data + "\n");
    }

    @Override
    public void postFlashEvent(IFlasherLogger.FlashEvents event, Object obj) {
        switch (event) {
            case COMPLETED: {
                this.logger.info("Flash End time (Success)" + System.currentTimeMillis());
                break;
            }
            case FAILED: {
                Exception e = (Exception)obj;
                this.logger.log(Level.WARNING, "Flash Failure ", e);
                this.logger.info("Flash End time (Fail) " + System.currentTimeMillis());
                System.err.println("XXX FATAL XXX " + e.toString());
                System.exit(2);
                break;
            }
            case PERCENT_UPDATE: {
                int percent = (Integer)obj;
                this.logger.log(Level.WARNING, "Percent update ", percent);
            }
        }
    }

    public static void usage() {
        System.out.println("WebOS Dr. CLI mode ");
        System.out.println("Required parameter - ");
        System.out.println(" --auto");
        System.out.println(" --goback");
        System.exit(1);
    }

    public static void cmdLineMain(String[] args) {
        boolean auto = false;
        boolean goback = false;
        System.out.println("WebOS Dr CLI mode");
        if (args.length == 0 || args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("--help"))) {
            CmdLineInterface.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].trim();
            if ("--auto".equalsIgnoreCase(args[i])) {
                auto = true;
            }
            if (!"--goback".equalsIgnoreCase(args[i])) continue;
            goback = true;
        }
        if (auto) {
            try {
                CmdLineInterface cli = new CmdLineInterface(goback);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("XXX FATAL XXX " + e.toString());
                System.exit(2);
            }
            System.out.println("Done flashing, device is ready for use");
        } else {
            System.out.println("no flashing attempted");
        }
        System.exit(0);
    }
}

