/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.internal.NovacomSocketStream;
import com.palm.novacom.internal.OOBPacket;
import com.palm.novacom.internal.PacketHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PacketReader {
    private final InputStream stream;
    PacketHeader packetHeader;
    byte[] packetData;
    int packetIndex;
    Vector<OOBPacket> oobPackets;

    protected PacketReader(InputStream stream) {
        this.stream = stream;
        this.packetHeader = new PacketHeader();
        this.packetData = new byte[32768];
        this.packetIndex = -1;
        this.oobPackets = new Vector();
    }

    void dumpByteArray(String prefix, byte[] b, int length) {
        StringBuilder buffer = new StringBuilder(prefix + ":");
        for (int i = 0; i < length; ++i) {
            buffer.append(" 0x" + Integer.toHexString(b[i] & 0xFF));
        }
        try {
            NovacomSocketStream.logger.warning(buffer.toString());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
    }

    private int readArray(byte[] data, int size) throws IOException {
        int count;
        try {
            int rc;
            for (count = 0; count < size; count += rc) {
                rc = this.stream.read(data, count, size - count);
                if (rc != -1) continue;
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Out of Bounds! -- " + data.length + "," + size + "," + count);
        }
        return count;
    }

    protected int readPacket() throws IOException {
        this.packetIndex = -1;
        int rc = this.readArray(this.packetHeader.getHeader(), 16);
        if (rc != 16) {
            return -1;
        }
        if (this.packetHeader.getMagic() != -557122643) {
            throw new IOException("Bad Magic Number in Packet!!! " + this.packetHeader.toString());
        }
        int type = this.packetHeader.getType();
        switch (type) {
            case 0: 
            case 1: {
                this.packetIndex = 0;
                this.readArray(this.packetData, this.packetHeader.getSize());
                break;
            }
            case 2: {
                OOBPacket oob = new OOBPacket();
                this.readArray(oob.getPacketData(), this.packetHeader.getSize());
                this.oobPackets.add(oob);
            }
        }
        return type;
    }

    public int read() throws IOException {
        int rc;
        if (this.packetIndex == -1 || this.packetIndex >= this.packetHeader.getSize()) {
            do {
                if ((rc = this.readPacket()) != -1) continue;
                return -1;
            } while (rc == 2);
        }
        if (this.packetIndex == -1) {
            return -1;
        }
        rc = this.packetData[this.packetIndex] & 0xFF;
        ++this.packetIndex;
        return rc;
    }

    public int read(byte[] b) throws IOException {
        int val;
        int i;
        if (b == null) {
            return -1;
        }
        for (i = 0; i < b.length && (val = this.read()) != -1; ++i) {
            b[i] = (byte)val;
        }
        return i;
    }

    public Vector<OOBPacket> getOOBPackets() {
        return this.oobPackets;
    }

    public boolean atPacketStart() {
        return this.packetIndex == -1 || this.packetIndex >= this.packetHeader.getSize();
    }
}

